package com.xebialabs.deployit.plugin.api.validation;

import com.google.common.base.Predicate;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Iterables.filter;
import static com.google.common.collect.Lists.newArrayList;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = NoSelfReference.Validator.class, type = "no-self-reference")
@Target(ElementType.TYPE)
public @interface NoSelfReference {
    
    String referenceField();
    
    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<ConfigurationItem> {

        private String referenceField;
        
        @Override
        public void validate(ConfigurationItem value, ValidationContext context) {
            final String id = value.getId();
            Collection<ConfigurationItem> property = value.getProperty(referenceField);
            List<ConfigurationItem> filter = newArrayList(filter(property, new Predicate<ConfigurationItem>() {
                public boolean apply(ConfigurationItem input) {
                    return input.getId().equals(id);
                }
            }));
            if (!filter.isEmpty()) {
                context.error("%s [%s] cannot contain a reference to itself.", value.getType(), id);
            }
        }
    }
}
