/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.artifact;

import com.xebialabs.deployit.plugin.credentials.Credentials;
import com.xebialabs.deployit.plugin.proxy.ProxySettings;

import java.util.Map;
import java.util.Set;

public interface SourceArtifact extends Artifact {

    String FILE_URI_PROPERTY_NAME = "fileUri";

    String CHECKSUM_PROPERTY_NAME = "checksum";

    Set<String> getPlaceholders();
    
    void setPlaceholders(Set<String> placeholders);

    String getTextFileNamesRegex();

    /**
     * @return regex that captures all the files that should not be scanned.
     */
    String getExcludeFileNamesRegex();

    /**
     * This will return a map that specifies which files map to which encodings.
     *
     * By default XL Deploy will use UTF-8 for replacing placeholders in files, unless this property contains a regex as key which matches the path of the file within the artifact.
     * If a key matches, XL Deploy will use the attached value in the map as encoding for replacing placeholders in the file.
     *
     * @return map that maps a regex to a target encoding for a file.
     */
    Map<String, String> getFileEncodings();

    /**
     * Returns the artifact location which can be resolved using an artifact resolver.
     */
    String getFileUri();

    /**
     * Returns the credentials for artifact location.
     */
    default Credentials getCredentials() {
        return null;
    }

    /**
     * Returns the proxy settings for artifact location.
     */
    default ProxySettings getProxySettings() {
        return null;
    }

    /**
     * Returns the (calculated or user-defined) checksum of the artifact file.
     */
    String getChecksum();
}
