/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import java.lang.annotation.*;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * A control task is a method that can be invoked on a ConfigurationItem, to perform some action.
 * For instance, that starting or stopping of a Container.
 *
 * <p>A @ControlTask method should adhere to the following rules:
 * <ul>
 *   <li>take either no parameters or a <code>{@code Map<String, String>}</code>.</li>
 *   <li>return a <code>{@code List<Step>}</code></li>
 * </ul>
 */
@PublicApiRef
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface ControlTask {

    String DEFAULT_DELEGATE = "methodInvoker";

    String label() default "";

    String description() default "no description";

    String parameterType() default "";

    String delegate() default DEFAULT_DELEGATE;

}
