/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.*;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashSet;
import java.util.Set;

/**
 * A {@link Deployable} deployed to a {@link Container}.
 */
@PublicApiRef
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The supertype of all Deployeds.")
public class BaseDeployed<D extends Deployable, C extends Container> extends BaseConfigurationItem implements Deployed<D, C> {

    @Property(required = false, description = "The deployable that this deployed is derived from.")
    @DeployedSpecific
    private D deployable;

    @Property(asContainment = true, description = "The container on which this deployed runs.")
    @DeployedSpecific
    private C container;

    @Property(description = "The set of created CIs.", asContainment = false, required = false, category = "Provisioning", hidden = true)
    @DeployedSpecific
    private Set<ConfigurationItem> boundConfigurationItems = new HashSet<>();

    /**
     * Default constructor should be public in order to be able to instantiate this.
     */
    public BaseDeployed() {
    }

    protected BaseDeployed(D deployable, C container) {
        this.deployable = deployable;
        this.container = container;
    }

    @Override
    public D getDeployable() {
        return deployable;
    }

    @Override
    public void setDeployable(D deployable) {
        this.deployable = deployable;
    }

    @Override
    public C getContainer() {
        return container;
    }

    @Override
    public void setContainer(C container) {
        this.container = container;
    }

    public void setBoundConfigurationItems(Set<ConfigurationItem> boundConfigurationItems) {
        this.boundConfigurationItems = boundConfigurationItems;
    }

    public Set<ConfigurationItem> getBoundConfigurationItems() {
        return boundConfigurationItems;
    }

}
