/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.validation.Validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class InputHint {
    private PropertyKind kind;
    private boolean required;
    private String prompt;
    private List<InputHintValue> values = new ArrayList<>();
    private Set<Validator<?>> validationRules = new HashSet<>();
    private String copyFromProperty;
    private Type referencedType;

    public InputHint() {
    }

    public InputHint(PropertyKind kind, boolean required, String prompt, List<InputHintValue> values, Set<Validator<?>> validationRules, String copyFromProperty, Type referencedType) {
        this.kind = kind;
        this.required = required;
        this.prompt = prompt;
        this.values = values;
        this.validationRules = validationRules;
        this.copyFromProperty = copyFromProperty;
        this.referencedType = referencedType;
    }

    public PropertyKind getKind() {
        return kind;
    }

    public void setKind(final PropertyKind kind) {
        this.kind = kind;
    }

    public List<InputHintValue> getValues() {
        return values;
    }

    public void setValues(final List<InputHintValue> values) {
        this.values = values;
    }

    public Set<Validator<?>> getValidationRules() {
        return validationRules;
    }

    public InputHint copyFrom(final InputHint inputHint) {
        if (inputHint == null) {
            return this;
        }
        this.setKind(inputHint.getKind());
        this.values = inputHint.values;
        this.validationRules = inputHint.getValidationRules();
        this.setPrompt(inputHint.getPrompt());
        this.setRequired(inputHint.isRequired());
        this.setCopyFromProperty(inputHint.copyFromProperty);
        this.setReferencedType(inputHint.referencedType);
        return this;
    }

    public static InputHint newInputHintFrom(InputHint inputHint) {
        return inputHint == null ? null : new InputHint().copyFrom(inputHint);
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public boolean isRequired() {
        return required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getCopyFromProperty() {
        return copyFromProperty;
    }

    public void setCopyFromProperty(final String copyFromProperty) {
        this.copyFromProperty = copyFromProperty;
    }

    public Type getReferencedType() {
        return referencedType;
    }

    public void setReferencedType(Type referencedType) {
        this.referencedType = referencedType;
    }

    public static class InputHintBuilder {
        public PropertyKind kind;
        public boolean required;
        public String prompt;
        public List<InputHintValue> values = new ArrayList<>();
        public Set<Validator<?>> validationRules = new HashSet<>();
        public String copyFromProperty;
        public Type referencedType;

        public InputHintBuilder construct(Consumer<InputHintBuilder> builderFunction) {
            builderFunction.accept(this);
            return this;
        }

        public InputHint constructInputHint() {
            return new InputHint(kind, required, prompt, values, validationRules, copyFromProperty, referencedType);
        }
    }
}
