/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasVersion;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

@ConfigurationItem(category="middleware", description="A WebSphere Application Server cell. Is a member of Host on which the deployment manager runs.", expandable=true)
public class WasCell
extends BaseConfigurationItem {
    private static final String CONFIG_DIR_NAME = "config";
    private static final String PLUGIN_FILENAME = "plugin-cfg.xml";
    @ConfigurationItemProperty
    private Host host;
    @ConfigurationItemProperty(required=true, label="WebSphere name", description="Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
    private String name;
    @ConfigurationItemProperty(required=false, label="Administrative username", description="Username which is used to login to the WebSphere Cell.")
    private String username;
    @ConfigurationItemProperty(required=false, label="Administrative password", description="Password which is used to login to the WebSphere Cell.", password=true)
    private String password;
    @ConfigurationItemProperty(required=true, label="WAS deployment manager profile path", description="Path of the WebSphere deployment manager profile.")
    private String wasHome;
    @ConfigurationItemProperty(required=true, label="WAS version", description="Version of WebSphere Application Server.")
    private WasVersion version;

    public String getWsadminPath() {
        String fileSep = this.host.getOperatingSystemFamily().getFileSeparator();
        return this.getWasHome() + fileSep + "bin" + fileSep + "wsadmin" + this.host.getOperatingSystemFamily().getScriptExtension();
    }

    public String getConfigDirPath() {
        String fileSep = this.host.getOperatingSystemFamily().getFileSeparator();
        return this.getWasHome() + fileSep + CONFIG_DIR_NAME;
    }

    public String getPluginFilePath() {
        String fileSep = this.host.getOperatingSystemFamily().getFileSeparator();
        return this.getConfigDirPath() + fileSep + "cells" + fileSep + PLUGIN_FILENAME;
    }

    public HostSession connectToAdminHost() {
        return this.host.getHostSession();
    }

    public int executeWsadminJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getWsadminPath());
        if (StringUtils.isNotBlank((String)this.getUsername())) {
            cmd.add("-user");
            cmd.add(this.getUsername());
            if (!StringUtils.isEmpty((String)this.getPassword())) {
                cmd.add("-password");
                cmd.add(this.getPassword());
            }
        }
        cmd.add("-lang");
        cmd.add("jython");
        cmd.add("-f");
        cmd.add(scriptPath);
        for (String arg : args) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    public WasVersion getVersion() {
        return this.version;
    }

    public void setVersion(WasVersion version) {
        this.version = version;
    }
}

