/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.runbook.WasRunBookBase;
import com.xebialabs.deployit.plugin.was.step.AddSingleWasClusterMemberStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasClusterMembersStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasClusterStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasClusterStep;
import com.xebialabs.deployit.plugin.was.step.ModifyWasClusterMemberStep;
import com.xebialabs.deployit.plugin.was.step.RemoveWasClusterMemberStep;
import com.xebialabs.deployit.plugin.was.step.StartWasClusterMembersStep;
import com.xebialabs.deployit.plugin.was.step.StopWasClusterStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasClusterRunBook
extends WasRunBookBase<WasCluster>
implements RunBook {
    public WasClusterRunBook() {
        super(WasCluster.class);
    }

    @Override
    public void resolve(Change<WasCluster> change, ChangePlan changePlan, List<Step> steps) {
        WasCluster newCluster;
        WasCluster oldCluster = (WasCluster)((Object)change.getOldRevision());
        boolean identical = ConfigurationItemReflectionUtils.isIdentical((Serializable)((Object)oldCluster), (Serializable)((Object)(newCluster = (WasCluster)((Object)change.getNewRevision()))));
        if (!identical) {
            WasCluster cluster;
            if (change.isModification() && !this.modificationWillBeHandledByWasDeploymentRunBook(change, changePlan)) {
                this.getStepsForModifiedCluster(steps, oldCluster, newCluster);
            }
            if (change.isDeletion()) {
                cluster = (WasCluster)((Object)change.getOldRevision());
                steps.add(new StopWasClusterStep(cluster, false));
                steps.add(new DestroyWasClusterStep(cluster));
            }
            if (change.isAddition()) {
                cluster = (WasCluster)((Object)change.getNewRevision());
                steps.add(new CreateWasClusterStep(cluster));
                for (WasNode eachNode : cluster.getNodes()) {
                    steps.add(new CreateWasClusterMembersStep(cluster, eachNode));
                    steps.add(new SynchronizeWasNodeStep(eachNode));
                    steps.add(new StartWasClusterMembersStep(cluster, eachNode));
                }
            }
        }
    }

    public void getStepsForModifiedCluster(List<Step> steps, WasCluster oldCluster, WasCluster newCluster) {
        steps.add(new StopWasClusterStep(oldCluster, false));
        for (WasNode eachNode : oldCluster.getNodes()) {
            int numberOfRemovedClones = this.removeClones(oldCluster, newCluster, eachNode, steps);
            for (int i = 1; i <= oldCluster.getNumberOfClusterMembers() - numberOfRemovedClones; ++i) {
                steps.add(new ModifyWasClusterMemberStep(oldCluster, eachNode, i));
            }
            this.createAdditionalClones(oldCluster, newCluster, eachNode, steps);
            steps.add(new StartWasClusterMembersStep(newCluster, eachNode));
        }
    }

    private boolean modificationWillBeHandledByWasDeploymentRunBook(Change<WasCluster> clusterChange, ChangePlan changePlan) {
        Change<Deployment> deploymentChange = this.findChangeForModifiedDeploymentOfModifiedCluster(clusterChange, changePlan);
        return deploymentChange != null;
    }

    private Change<Deployment> findChangeForModifiedDeploymentOfModifiedCluster(Change<WasCluster> clusterChange, ChangePlan changePlan) {
        if (!clusterChange.isModification()) {
            return null;
        }
        for (Change change : changePlan.getChanges()) {
            if (!change.isModification() || change.getConfigurationItemClass() != Deployment.class) continue;
            WasCluster oldCluster = (WasCluster)((Object)clusterChange.getOldRevision());
            WasCluster newCluster = (WasCluster)((Object)clusterChange.getNewRevision());
            Deployment oldDeployment = (Deployment)change.getOldRevision();
            Deployment newDeployment = (Deployment)change.getNewRevision();
            boolean oldClusterWasTarget = oldDeployment.getTarget().getMembersOfType(WasCluster.class).contains((Object)oldCluster);
            boolean newClusterWasTarget = newDeployment.getTarget().getMembersOfType(WasCluster.class).contains((Object)newCluster);
            if (!oldClusterWasTarget || !newClusterWasTarget) continue;
            return change;
        }
        return null;
    }

    private int removeClones(WasCluster oldCluster, WasCluster newCluster, WasNode eachNode, List<Step> steps) {
        int diff = oldCluster.getNumberOfClusterMembers() - newCluster.getNumberOfClusterMembers();
        if (diff > 0) {
            for (int i = oldCluster.getNumberOfClusterMembers(); i > newCluster.getNumberOfClusterMembers(); --i) {
                steps.add(new RemoveWasClusterMemberStep(oldCluster, eachNode, i));
            }
            return diff;
        }
        return 0;
    }

    private void createAdditionalClones(WasCluster oldCluster, WasCluster newCluster, WasNode eachNode, List<Step> steps) {
        int diff = newCluster.getNumberOfClusterMembers() - oldCluster.getNumberOfClusterMembers();
        if (diff > 0) {
            for (int i = oldCluster.getNumberOfClusterMembers() + 1; i <= newCluster.getNumberOfClusterMembers(); ++i) {
                steps.add(new AddSingleWasClusterMemberStep(newCluster, eachNode, i));
            }
        }
    }
}

