/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class RemoveWasClusterMemberStep
extends WasStepBase {
    protected static final String REMOVE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/remove-cluster-member.py";
    protected WasCluster cluster;
    protected WasNode node;
    private int cloneNumber;

    public RemoveWasClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
        super(cluster.getCell());
        this.cloneNumber = cloneNumber;
        this.cluster = cluster;
        this.node = node;
        this.setDescription("Remove member " + cloneNumber + " for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \"" + this.cell.getLabel() + "\"");
    }

    public boolean execute(StepExecutionContext ctx) {
        String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(this.cluster.getName(), this.node.getName());
        return this.executeWsadminJythonScriptResource(ctx, REMOVE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, this.node.getName(), this.cluster.getName(), clusterMemberNamesPrefix, Integer.toString(this.cloneNumber)) == 0;
    }
}

