/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import org.apache.commons.lang.StringUtils;

public class UpdateWasVirtualHostAliasesStep
extends WasStepBase {
    protected static final String UPDATE_VIRTUAL_HOST_ALIASES_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/update-vhost-aliases.py";
    protected String vhostName;
    protected String aliasHostName;
    protected String aliasPortNumber;

    public UpdateWasVirtualHostAliasesStep(WasCell cell, String vhostName, String alias) {
        super(cell);
        this.vhostName = vhostName;
        String[] aliasComponents = StringUtils.split((String)alias, (char)':');
        if (aliasComponents == null || aliasComponents.length != 2) {
            throw new ResolutionException("Virtual host definition \"" + alias + "\" is not a valid host specification");
        }
        this.aliasHostName = aliasComponents[0];
        this.aliasPortNumber = aliasComponents[1];
        this.setDescription("Add alias " + this.aliasHostName + ":" + this.aliasPortNumber + " to WAS virtual host " + vhostName + " in cell " + ExtendedStringUtils.getQuotedString((String)cell.getLabel()));
    }

    public boolean execute(StepExecutionContext ctx) {
        return this.executeWsadminJythonScriptResource(ctx, UPDATE_VIRTUAL_HOST_ALIASES_SCRIPT_RESOURCE_PATH, this.vhostName, this.aliasPortNumber, this.aliasHostName) == 0;
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public String getAliasHostName() {
        return this.aliasHostName;
    }

    public String getAliasPortNumber() {
        return this.aliasPortNumber;
    }
}

