/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.mapper.JeeArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationOnServersStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarToWasServerMapper
extends JeeArtifactToWasTargetMapper<Ear, WasEarMapping, WasServer> {
    public EarToWasServerMapper(Change<Deployment> change) {
        super(change, true);
    }

    @Override
    protected void generateDeployStep(Ear artifact, WasEarMapping mapping, WasServer server, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationOnServersStep(server.getCell(), artifact, Collections.singleton(server), webservers, artifact.getName(), mapping.getStartingWeight()));
    }

    @Override
    protected void generateUndeployStep(Ear artifact, WasServer server, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep(server.getCell(), artifact));
    }

    @Override
    protected void generateStartStep(Ear artifact, WasServer server, List<Step> steps) {
        steps.add(new WasStartApplicationStep(server, artifact));
    }

    @Override
    protected void generateStopStep(Ear artifact, WasServer server, List<Step> steps) {
        steps.add(new WasStopApplicationStep(server, artifact));
    }

    @Override
    protected String getVirtualHostFromMapping(WasEarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasEarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
    }
}

