/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.mapper.WasStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.step.CreateWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasVirtualHostAliasesStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JeeArtifactToWasTargetMapper<S extends NamedDeployableArtifact, M extends Mapping, T extends WasTarget>
extends WasStepGeneratingMapper<S, M, T> {
    public JeeArtifactToWasTargetMapper(Change<Deployment> change, boolean applyDefaultMappings) {
        super(change, applyDefaultMappings);
    }

    protected final void generateAdditionStepsForAddedMapping(S ear, M mapping, T target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = mapping instanceof WasEarMapping ? ((WasEarMapping)((Object)mapping)).getWebservers() : (mapping instanceof WasWarMapping ? ((WasWarMapping)((Object)mapping)).getWebservers() : Collections.emptySet());
        steps.add(new CreateWasVirtualHostStep(((WasTarget)((Object)target)).getCell(), ear.getName()));
        steps.add(new UpdateWasVirtualHostAliasesStep(((WasTarget)((Object)target)).getCell(), ear.getName(), this.getVirtualHostFromMapping(mapping)));
        this.generateDeployStep(ear, mapping, target, webservers, steps);
        for (WasManagedApacheHttpdServer eachWebServer : webservers) {
            this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, this.getVirtualHostFromMapping(mapping));
        }
        for (WasNode eachNode : ((WasTarget)((Object)target)).getNodes()) {
            steps.add(new SynchronizeWasNodeStep(eachNode));
        }
        this.generateStartStep(ear, target, steps);
    }

    protected final void generateDeletionStepsForDeletedMapping(S ear, M mapping, T target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = mapping instanceof WasEarMapping ? ((WasEarMapping)((Object)mapping)).getWebservers() : (mapping instanceof WasWarMapping ? ((WasWarMapping)((Object)mapping)).getWebservers() : Collections.emptySet());
        this.generateStopStep(ear, target, steps);
        this.generateUndeployStep(ear, target, steps);
        steps.add(new DestroyWasVirtualHostStep(((WasTarget)((Object)target)).getCell(), ear.getName()));
        for (WasNode eachNode : ((WasTarget)((Object)target)).getNodes()) {
            steps.add(new SynchronizeWasNodeStep(eachNode));
        }
        for (WasManagedApacheHttpdServer eachWebServer : webservers) {
            this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, this.getVirtualHostFromMapping(mapping));
        }
    }

    protected abstract String getVirtualHostFromMapping(M var1);

    protected abstract void generateDeployStep(S var1, M var2, T var3, Collection<WasManagedApacheHttpdServer> var4, List<Step> var5);

    protected abstract void generateUndeployStep(S var1, T var2, List<Step> var3);

    protected abstract void generateStartStep(S var1, T var2, List<Step> var3);

    protected abstract void generateStopStep(S var1, T var2, List<Step> var3);
}

