/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.io.Serializable;
import java.util.HashMap;

public class CreateWasWmqTopicConnectionFactoryStep
extends WasStepBase
implements Step {
    private static final String CREATE_WMQ_TCF_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-wmq-topic-connection-factory.py";
    private WasCluster cluster;
    private WasServer server;
    private WasWmqTopicConnectionFactory topicConnectionFactory;

    public CreateWasWmqTopicConnectionFactoryStep(WasCluster cluster, WasWmqTopicConnectionFactory tcf) {
        super(cluster.getCell());
        this.cluster = cluster;
        this.server = null;
        this.topicConnectionFactory = tcf;
        this.setDescription("Create WebSphere MQ Topic Connection Factory " + ExtendedStringUtils.getQuotedString((String)tcf.getLabel()) + " in cluster " + cluster.getLabel());
    }

    public CreateWasWmqTopicConnectionFactoryStep(WasServer server, WasWmqTopicConnectionFactory tcf) {
        super(server.getNode().getCell());
        this.cluster = null;
        this.server = server;
        this.topicConnectionFactory = tcf;
        this.setDescription("Create WebSphere MQ Topic Connection Factory " + ExtendedStringUtils.getQuotedString((String)tcf.getLabel()) + " in server " + server.getLabel());
    }

    public boolean execute(StepExecutionContext ctx) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        if (this.cluster != null) {
            context.put("cluster", (Serializable)((Object)this.cluster));
        }
        if (this.server != null) {
            context.put("server", (Serializable)((Object)this.server));
            context.put("node", (Serializable)((Object)this.server.getNode()));
            context.put("cell", (Serializable)((Object)this.server.getNode().getCell()));
        }
        context.put("tcf", this.topicConnectionFactory);
        context.put("tcfQueueManagerHost", (Serializable)this.topicConnectionFactory.getQueueManagerHost());
        int res = this.executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_TCF_SCRIPT_RESOURCE_PATH, new String[0]);
        return res == 0;
    }
}

