package com.xebialabs.deployit.plugin.was.ci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;

@SuppressWarnings("serial")
public class WasWarMapping extends WarMapping {

	private Set<WasManagedApacheHttpdServer> webservers;

	public WasWarMapping() {
		// default constructor
	}

	@SuppressWarnings("unchecked")
	public WasWarMapping(War source, Serializable target, String virtualHost, String contextRoot) {
		this(source, target, (Set<WasManagedApacheHttpdServer>) Collections.EMPTY_SET, virtualHost, contextRoot);
	}

	public WasWarMapping(War source, Serializable target, Set<WasManagedApacheHttpdServer> webservers, String virtualHost, String contextRoot) {
		super(source, target, virtualHost, contextRoot);
		this.webservers = webservers;
	}

	public Set<WasManagedApacheHttpdServer> getWebservers() {
		return webservers;
	}

	public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
		this.webservers = webservers;
	}

}
