package com.xebialabs.deployit.plugin.was.mapper;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;

public abstract class WasStepGeneratingMapper<S extends Serializable, M extends Mapping, T extends Serializable> extends StepGeneratingMapper<S, M, T> {

	protected Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer;

	protected WasStepGeneratingMapper(Change<Deployment> change, boolean applyDefaultMappings) {
		super(change, applyDefaultMappings);
	}

	protected void associateVirtualHostWithWebServer(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, ApacheHttpdServer eachWebServer,
			String virtualHost) {
		Set<String> virtualHosts = virtualHostsPerWebServer.get(eachWebServer);
		if (virtualHosts == null) {
			virtualHosts = new HashSet<String>();
			virtualHostsPerWebServer.put(eachWebServer, virtualHosts);
		}
		virtualHosts.add(virtualHost);
	}

	public void setVirtualHostsPerWebServerCollector(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer) {
		this.virtualHostsPerWebServer = virtualHostsPerWebServer;
	}

}
