package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqTopicConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqTopicConnectionFactoryStep;

public class WasWmqTopicConnectionFactoryToWasClusterMapper extends MappingAgnosticStepGeneratingMapper<WasWmqTopicConnectionFactory, WasCluster> {

	public WasWmqTopicConnectionFactoryToWasClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasWmqTopicConnectionFactory resource, WasCluster cluster, List<Step> steps) {
		steps.add(new CreateWasWmqTopicConnectionFactoryStep(cluster, resource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasWmqTopicConnectionFactory resource, WasCluster cluster, List<Step> steps) {
		steps.add(new DestroyWasWmqTopicConnectionFactoryStep(cluster, resource));
	}

}
