package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;

/**
 * Adds a number of members (Server) to a {@link WasCluster WAS Cluster} on a {@link WasNode}.
 */
@SuppressWarnings("serial")
public class CreateWasClusterMembersStep extends WasStepBase {

	protected static final String CREATE_CLUSTER_MEMBERS_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-cluster-members.py";

	protected WasCluster cluster;

	protected WasNode node;

	public CreateWasClusterMembersStep(WasCluster cluster, WasNode node) {
		this(cluster.getCell().getHost(), cluster.getCell(), cluster, node);
	}

	public CreateWasClusterMembersStep(Host cellHost, WasCell cell, WasCluster cluster, WasNode node) {
		super(cell);
		this.cluster = cluster;
		this.node = node;
		setDescription("Create members for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \"" + cell.getLabel() + "\"");
	}

	public boolean execute(StepExecutionContext ctx) {
		String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(cluster.getName(), node.getName());
		String numberOfClusterMembers = Integer.toString(cluster.getNumberOfClusterMembers());
		String startOfBootstrapPortNumberRange = Integer.toString(cluster.getStartOfBootstrapPortNumberRange());
		String startOfSoapConnectorPortNumberRange = Integer.toString(cluster.getStartOfSoapConnectorPortNumberRange());

		return (executeWsadminJythonScriptResource(ctx, CREATE_CLUSTER_MEMBERS_SCRIPT_RESOURCE_PATH, node.getName(), cluster.getName(), clusterMemberNamesPrefix, numberOfClusterMembers,
				startOfBootstrapPortNumberRange, "BOOTSTRAP_ADDRESS", startOfSoapConnectorPortNumberRange, "SOAP_CONNECTOR_ADDRESS") == 0);
	}

}
