package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory;

/**
 * Creates a {@link WasWmqTopicConnectionFactory} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class CreateWasWmqTopicConnectionFactoryStep extends WasStepBase implements Step {

	private static final String CREATE_WMQ_TCF_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-wmq-topic-connection-factory.py";
	
	private WasCluster cluster;
	private WasWmqTopicConnectionFactory topicConnectionFactory;

	public CreateWasWmqTopicConnectionFactoryStep(WasCluster existingCluster, WasWmqTopicConnectionFactory tcf) {
		super(existingCluster.getCell());
		this.cluster = existingCluster;
		this.topicConnectionFactory = tcf;
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cluster", cluster);
		context.put("tcf", topicConnectionFactory);
		context.put("tcfQueueManagerHost", topicConnectionFactory.getQueueManagerHost());
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_TCF_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
