package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasDataSource;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Destroys a {@link WasDataSource} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class DestroyWasDataSourceStep extends WasStepBase {

	public static final String DESTROY_DATASOURCE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-datasource.py";

	private WasDataSource wasDataSource;

	private WasCluster cluster;

	public DestroyWasDataSourceStep(WasDataSource wasDataSource, WasCluster cluster) {
		super(cluster.getCell());
		this.wasDataSource = wasDataSource;
		this.cluster = cluster;
		setDescription("Destroy datasource " + ExtendedStringUtils.getQuotedString(wasDataSource.getLabel()) + " in cell "
				+ ExtendedStringUtils.getQuotedString(cluster.getCell().getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return executeWsadminJythonScriptResource(ctx, DESTROY_DATASOURCE_SCRIPT_RESOURCE_PATH, wasDataSource.getName(), wasDataSource.getProvider(), cell.getName(), cluster.getName()) == 0;
	}

}
