package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Destroys a {@link WasWmqTopicConnectionFactory} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class DestroyWasWmqTopicConnectionFactoryStep extends WasStepBase {
	
	public static String DESTROY_WMQ_TCF_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-wmq-topic-connection-factory.py";

	private WasCluster cluster;
	private WasWmqTopicConnectionFactory tcf;

	public DestroyWasWmqTopicConnectionFactoryStep(WasCluster cluster, WasWmqTopicConnectionFactory tcf) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.tcf = tcf;
		setDescription("Destroy WebSphere MQ Topic Connection Factory "  + ExtendedStringUtils.getQuotedString(tcf.getLabel()) + " in cluster "  + cluster.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cluster", cluster);
		context.put("tcf", tcf);
		context.put("tcfQueueManagerHost", tcf.getQueueManagerHost());
		int res = executeWsadminJythonScriptResource(ctx, context, DESTROY_WMQ_TCF_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
