package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Stops the {@link WasCluster} on a {@link WasCell}
 */
@SuppressWarnings("serial")
public class StopWasClusterStep extends WasStepBase {

	protected static final String STOP_CLUSTER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "stop-cluster.py";

	protected WasCluster cluster;

	protected boolean forced;

	public StopWasClusterStep(WasCluster cluster, boolean forced) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.forced = forced;
		String forcibly = "";
		if (forced) {
			forcibly = "(forcibly) ";
		}
		setDescription("Stop cluster " + forcibly + ExtendedStringUtils.getQuotedString(cluster.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, STOP_CLUSTER_SCRIPT_RESOURCE_PATH, cluster.getName(), Boolean.toString(forced)) == 0);
	}

}
