package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Checks if an {@link NamedDeployableArtifact application} is ready to be started on a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class WasIsAppReadyStep extends WasStepBase {

	protected static final String IS_APP_READY_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "is-app-ready.py";

	protected WasCluster cluster;

	protected NamedDeployableArtifact application;

	protected WasIsAppReadyStep(WasCluster cluster, NamedDeployableArtifact application) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.application = application;

		setDescription("Is application " + ExtendedStringUtils.getQuotedString(application.getLabel()) + " on cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel())
				+ " ready?");
	}

	public boolean execute(StepExecutionContext ctx) {
		String[] args = new String[1];
		args[0] = application.getName();
		return executeWsadminJythonScriptResource(ctx, IS_APP_READY_SCRIPT_RESOURCE_PATH, args) == 0;
	}
}
