/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;

/**
 * Tells the {@link WasDeploymentManager} to generate a webserver plugin configuration for a {@link WasUnManagedApacheHttpdServer}
 */
@SuppressWarnings("serial")
public class GenerateWasUnManagedWebServerPluginConfigurationStep extends WasStepBase {

	public static final String GENERATE_PLUGIN_CONFIG_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "generate-plugin-config.py";

	protected WasUnManagedApacheHttpdServer webserver;

	public GenerateWasUnManagedWebServerPluginConfigurationStep(WasUnManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		this.description = "Generating plugin for webserver " + webserver + " on node " + webserver.getNode() + " on cell " + cell;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = cell.connectToAdminHost();
		int res = 0;
		try {
			String[] args = { cell.getCellName(), webserver.getNode().getNodeName(), webserver.getName(), cell.getWasHome() + "/config" };
			res = executeWsadminJythonScriptResource(ctx, rhs, GENERATE_PLUGIN_CONFIG_SCRIPT_RESOURCE_PATH, args);
		} finally {
			rhs.close();
		}
		return res == 0;
	}

	public String getPluginConfigurationFilePath() {
		return cell.getWasHome() + "/config/cells/" + cell.getCellName() + "/nodes/" + webserver.getNode().getNodeName() + "/servers/" + webserver.getName()
		        + "/plugin-cfg.xml";
	}

}
