/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderPolicyAndMode;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WasServer
extends BaseConfigurationItem
implements WasTarget {
    @ConfigurationItemProperty(required=true, label="WebSphere name", identifying=true, description="Name of the WebSphere server, e.g. server1")
    private String name;
    @ConfigurationItemProperty(required=false, label="Classpath", description="Classpath for this server.", size=ConfigurationItemProperty.Size.LARGE, category="JVM")
    private String classpath;
    @ConfigurationItemProperty(required=false, label="Boot classpath", description="Boot classpath for this server.", size=ConfigurationItemProperty.Size.LARGE, category="JVM")
    private String bootClasspath;
    @ConfigurationItemProperty(required=false, label="Initial heap size", description="Initial heap size to be allocated to the JVM (in megabytes).", size=ConfigurationItemProperty.Size.SMALL, category="JVM")
    private int initHeapSize;
    @ConfigurationItemProperty(required=false, label="Maximum heap size", description="Maximum heap size to be allocated to the JVM (in megabytes).", size=ConfigurationItemProperty.Size.SMALL, category="JVM")
    private int maxHeapSize;
    @ConfigurationItemProperty(required=false, label="JVM arguments", description="Generic JVM arguments.", size=ConfigurationItemProperty.Size.LARGE, category="JVM")
    private String jvmArguments;
    @ConfigurationItemProperty(required=false, label="Disable JIT", description="Disable just-in-time compiler.", category="JVM")
    private boolean disableJit;
    @ConfigurationItemProperty(required=false, label="Classloader policy and mode", description="Server-wide application classloader policy and mode", category="JVM")
    private WasClassLoaderPolicyAndMode applicationClassLoaderPolicyAndMode;
    @ConfigurationItemProperty(required=false, label="Working directory", description="Working directory of started process.", size=ConfigurationItemProperty.Size.LARGE, category="JVM")
    private String workingDir;
    @ConfigurationItemProperty(required=false, label="Unix umask", description="Umask of started process.", category="JVM")
    private String umask;
    @ConfigurationItemProperty(required=false, label="Stdout logfile path", description="Path to the stdout log file. Example; /data/waslogs/stdout.log", size=ConfigurationItemProperty.Size.LARGE, category="Logging")
    private String stdOut;
    @ConfigurationItemProperty(required=false, label="Stderr logfile path", description="Path to the stderr log file. Example; /data/waslogs/stderr.log", size=ConfigurationItemProperty.Size.LARGE, category="Logging")
    private String stdErr;
    @ConfigurationItemProperty(required=false, label="JVM stdout logfile path", description="Path to the JVM stdout log file. Example; /data/waslogs/jvm_stdout.log", size=ConfigurationItemProperty.Size.LARGE, category="Logging")
    private String jvmStdOut;
    @ConfigurationItemProperty(required=false, label="JVM stderr logfile path", description="Path to the JVM stderr log file. Example; /data/waslogs/jvm_stderr.log", size=ConfigurationItemProperty.Size.LARGE, category="Logging")
    private String jvmStdErr;
    @ConfigurationItemProperty(required=false, label="Enable servlet caching", category="Web container")
    private boolean servletCaching = false;
    @ConfigurationItemProperty(required=false, label="Session timeout", description="HTTP session timeout in minutes", category="Web container")
    private int sessionTimeout = 30;
    @ConfigurationItemProperty(required=false, label="Max # of sessions in memory", description="Maximum # of HTTP sessions in memory", category="Web container")
    private int maximumSessionsInMemory = 1000;
    @ConfigurationItemProperty(required=false, label="Enable session cookies", category="Web container")
    private boolean enableSessionCookies = false;
    @ConfigurationItemProperty(required=false, label="Session cookie name", category="Web container")
    private String cookieName = null;
    @ConfigurationItemProperty(required=false, label="Session cookie domain", category="Web container")
    private String cookieDomain = null;
    @ConfigurationItemProperty(required=false, label="Session cookie path", category="Web container")
    private String cookiePath = null;
    @ConfigurationItemProperty(required=false, label="Environment entries", category="JVM")
    private List<KeyValuePair> environmentEntries = Lists.newArrayList();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(String bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    public int getInitHeapSize() {
        return this.initHeapSize;
    }

    public void setInitHeapSize(int initHeapSize) {
        this.initHeapSize = initHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public String getJvmArguments() {
        return this.jvmArguments;
    }

    public void setJvmArguments(String jvmArguments) {
        this.jvmArguments = jvmArguments;
    }

    public boolean getDisableJit() {
        return this.disableJit;
    }

    public void setDisableJit(boolean disableJit) {
        this.disableJit = disableJit;
    }

    public WasClassLoaderPolicyAndMode getApplicationClassLoaderPolicyAndMode() {
        return this.applicationClassLoaderPolicyAndMode;
    }

    public void setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode applicationClassLoaderPolicyAndMode) {
        this.applicationClassLoaderPolicyAndMode = applicationClassLoaderPolicyAndMode;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public void setStdOut(String stdOut) {
        this.stdOut = stdOut;
    }

    public String getStdErr() {
        return this.stdErr;
    }

    public void setStdErr(String stdErr) {
        this.stdErr = stdErr;
    }

    public String getJvmStdOut() {
        return this.jvmStdOut;
    }

    public void setJvmStdOut(String jvmStdOut) {
        this.jvmStdOut = jvmStdOut;
    }

    public String getJvmStdErr() {
        return this.jvmStdErr;
    }

    public void setJvmStdErr(String jvmStdErr) {
        this.jvmStdErr = jvmStdErr;
    }

    public boolean getServletCaching() {
        return this.servletCaching;
    }

    public void setServletCaching(boolean servletCaching) {
        this.servletCaching = servletCaching;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getMaximumSessionsInMemory() {
        return this.maximumSessionsInMemory;
    }

    public void setMaximumSessionsInMemory(int maximumSessionsInMemory) {
        this.maximumSessionsInMemory = maximumSessionsInMemory;
    }

    public boolean getEnableSessionCookies() {
        return this.enableSessionCookies;
    }

    public void setEnableSessionCookies(boolean enableSessionCookies) {
        this.enableSessionCookies = enableSessionCookies;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public abstract String getNodeName();

    public List<KeyValuePair> getEnvironmentEntries() {
        return this.environmentEntries;
    }

    public void setEnvironmentEntries(List<KeyValuePair> environmentEntries) {
        this.environmentEntries = environmentEntries;
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        String appMgrObjectName = "cell=" + this.getCell().getCellName() + ",node=" + this.getNodeName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(appMgrObjectName);
    }
}

