/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerApplicationServerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerErrorStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaProcessPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaVirtualMachinePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerProcessExecutionPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerDefaultCookiePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerTuningPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerWebContainerPropertiesStep;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "A WebSphere server managed by a Node that is part of a deployment manager (WAS ND)", discoverable = true)
public class WasManagedServer extends WasServer implements Discoverable<WasManagedServer> {

	@ConfigurationItemProperty(label = "WebSphere node")
	private WasNodeAgent node;

	public WasNodeAgent getNode() {
		return node;
	}

	public void setNode(WasNodeAgent node) {
		this.node = node;
	}

	public WasDeploymentManager getCell() {
		return this.getNode().getCell();
	}

	public Collection<WasNodeAgent> getNodes() {
		return Collections.singleton(this.getNode());
	}

	public WasManagedServer discover(Map<String, Object> info, ChangePlan cp) {
		List<Step> steps = getCheckSteps();
		cp.addSteps(steps);
		cp.execute(info);
		return this;
	}

	private List<Step> getCheckSteps() {
		List<Step> steps = new ArrayList<Step>();
		steps.add(new RetrieveWasServerApplicationServerPropertiesStep(this));
		steps.add(new RetrieveWasServerErrorStreamRedirectPropertiesStep(this));
		steps.add(new RetrieveWasServerJavaProcessPropertiesStep(this));
		steps.add(new RetrieveWasServerJavaVirtualMachinePropertiesStep(this));
		steps.add(new RetrieveWasServerOutputRedirectPropertiesStep(this));
		steps.add(new RetrieveWasServerOutputStreamRedirectPropertiesStep(this));
		steps.add(new RetrieveWasServerProcessExecutionPropertiesStep(this));
		steps.add(new RetrieveWasServerSessionManagerDefaultCookiePropertiesStep(this));
		steps.add(new RetrieveWasServerSessionManagerPropertiesStep(this));
		steps.add(new RetrieveWasServerTuningPropertiesStep(this));
		steps.add(new RetrieveWasServerWebContainerPropertiesStep(this));
		return steps;
	}

	public WasManagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getWasConfigIdType() {
		return "Server";
	}

	public String getWasTargetType() {
		return "server";
	}

	public String getShortTypeDescription() {
		return "managed server";
	}

	@Override
	public String getNodeName() {
		return getNode().getName();
	}
}
