/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "A WebSphere Node. Is a member of the WebSphereCell to which it belongs and the Host in which it runs.")
public class WasNodeAgent extends BaseConfigurationItem implements WasNode {

	@ConfigurationItemProperty(required = true, label = "WebSphere administrative cell")
	private WasDeploymentManager cell;

	@ConfigurationItemProperty(required = true, label = "WebSphere name", identifying=true, description = "Name of the WebSphere node in the WebSphere cell, e.g. MyNode, Node01")
	private String name;

	public WasDeploymentManager getCell() {
		return cell;
	}

	public void setCell(WasDeploymentManager cell) {
		this.cell = cell;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getNodeName() {
		return getName();
	}

	public void setNodeName(String nodeName) {
		setName(nodeName);
	}

	public String getShortTypeDescription() {
		return "node";
	}

	public String getWasConfigIdType() {
		return "Node";
	}

	public String getWasTargetType() {
		return "Node";
	}


}