/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */


package com.xebialabs.deployit.plugin.was.ci;

import java.util.Set;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.Libraries;


@SuppressWarnings("serial")
@ConfigurationItem
public class WasSharedLibrary extends BaseConfigurationItem implements WasResource {

	@ConfigurationItemProperty(required = true, identifying = true, description = "Name of the shared library so it can be used by reference in an Application")
	private String name;

	@ConfigurationItemProperty(description = "The set of libraries that are part of this shared library")
	private Set<Libraries> libraries = Sets.newHashSet();

	@ConfigurationItemProperty(description = "The set of configuration files that are part of this shared library")
	private Set<ConfigurationFiles> configurationFiles = Sets.newHashSet();

	@ConfigurationItemProperty(description = "classpath of the shared library, e.g. /var/shared/log4j.jar;/var/shared/lib/ora/ojdbc14.jar")
	private String classPath;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Set<Libraries> getLibraries() {
		return libraries;
	}

	public void setLibraries(Set<Libraries> libraries) {
		this.libraries = libraries;
	}

	public Set<ConfigurationFiles> getConfigurationFiles() {
		return configurationFiles;
	}

	public void setConfigurationFiles(Set<ConfigurationFiles> configurationFiles) {
		this.configurationFiles = configurationFiles;
	}

	public String getClassPath() {
		return classPath;
	}

	public void setClassPath(String classPath) {
		this.classPath = classPath;
	}
}