/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;

/**
 * Undeploys a {@link NamedDeployableArtifact} from a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class WasUndeployApplicationStep extends WasStepBase {

	protected static final String UNDEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "undeploy-application.py";

	private NamedDeployableArtifact application;

	public WasUndeployApplicationStep(WasCell cell, Ear ear) {
		super(cell);
		this.application = ear;
		init();
	}

	public WasUndeployApplicationStep(WasCell cell, War war) {
		super(cell);
		this.application = war;
		init();
	}

	public WasUndeployApplicationStep(WasCell cell, EjbJar ejbJar) {
		super(cell);
		this.application = ejbJar;
		init();
	}

	private void init() {
		setDescription("Undeploy application " + application);
	}

	public boolean execute(StepExecutionContext ctx) {
		int res = executeWsadminJythonScriptResource(ctx, UNDEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH, application.getName());
		return res == 0;
	}

	public NamedDeployableArtifact getApplication() {
		return application;
	}

}
