/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;

public class WasUtils {

	public static NodeList getNodesWithTag(String tag, NamedDeployableArtifact artifact, String jarEntryName) {
		// look into the web.xml file
		try {
			JarFile jarFile = new JarFile(new File(artifact.getLocation()));
			JarEntry jarEntry = jarFile.getJarEntry(jarEntryName);
			if (jarEntry != null) {
				InputStream is = jarFile.getInputStream(jarEntry);
				DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
				DocumentBuilder db = dbf.newDocumentBuilder();
				disableDtdValidation(db);
				Document doc = db.parse(new InputSource(is));
				NodeList resourceRefNodes = doc.getElementsByTagName(tag);
				is.close();
				jarFile.close();
				return resourceRefNodes;
			} else {
				return null;
			}
		} catch (IOException e) {
			throw new RuntimeException("Ear file not found for Ear named " + artifact.getName());
		} catch (ParserConfigurationException e) {
			throw new RuntimeException("Parser configuration Exception while trying to parse application.xml for Ear named " + artifact.getName());
		} catch (SAXException e) {
			throw new RuntimeException("Parser Exception while parsing application.xml for Ear named " + artifact.getName());
		}
	}

	public static void disableDtdValidation(DocumentBuilder db) {
		// disable the dtd validation by setting a custom entity resolver
		db.setEntityResolver(new EntityResolver() {
			public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
				System.out.println("Ignoring " + publicId + ", " + systemId);
				return new InputSource(new StringReader(""));
			}
		});
	}

	public static String findName(Element element, String tagnameOfChild) {
		NodeList refNameElements = element.getElementsByTagName(tagnameOfChild);
		if (refNameElements.getLength() == 1) {
			Node refNameElement = refNameElements.item(0);
			return refNameElement.getFirstChild().getNodeValue();
		}
		return null;
	}

}
