package com.xebialabs.deployit.plugin.was.utils;

import static org.apache.commons.lang.StringUtils.EMPTY;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;

/**
 * Generates WebSphere names for artifacts, virtual hosts etc.
 */
public class WebSphereNameBuilder {
	private static final char NAME_TARGET_SEPARATOR = '-';
	
	public static String getDeployedApplicationName(Ear ear, WasEarMapping earMapping) {
		return addTargetSuffixIfRequested(ear, earMapping.getTarget(), 
				earMapping.isSuffixArtifactNameWithTarget());
	}
	
	private static String addTargetSuffixIfRequested(NamedDeployableArtifact jeeArtifact, 
			WasTarget target, boolean suffixRequested) {
		String artifactName = jeeArtifact.getName();
		return artifactName + (suffixRequested ? NAME_TARGET_SEPARATOR + target.getName() : EMPTY);
	}
	
	public static String getDeployedApplicationName(War war, WasWarMapping warMapping) {
		return addTargetSuffixIfRequested(war, warMapping.getTarget(), 
				warMapping.isSuffixArtifactNameWithTarget());
	}
	
//	public static String getVhostName(Ear ear, WasEarMapping earMapping) {
//		return getDeployedApplicationName(ear, earMapping);
//	}
//	
//	public static String getVhostName(War war, WasWarMapping warMapping) {
//		return getDeployedApplicationName(war, warMapping);
//	}
}
