/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(category="middleware", discoverable=true, description="A WebSphere cluster managed by a deployment manager (WAS ND)")
public class WasCluster
extends BaseConfigurationItem
implements WasTarget,
Discoverable<WasCluster> {
    @ConfigurationItemProperty(required=true, label="WebSphere administrative cell")
    private WasDeploymentManager cell;
    @ConfigurationItemProperty(required=true, label="WebSphere name", description="Name of the WebSphere cluster, e.g. cluster1", identifying=true)
    private String name;
    @ConfigurationItemProperty(label="Cluster server members", description="Set of servers that are part of this cluster")
    private Set<WasManagedServer> servers;

    public void setServers(Set<WasManagedServer> servers) {
        this.servers = servers;
    }

    public Set<WasManagedServer> getServers() {
        return this.servers;
    }

    @Override
    public WasDeploymentManager getCell() {
        return this.cell;
    }

    public void setCell(WasDeploymentManager cell) {
        this.cell = cell;
    }

    public Map<WasNodeAgent, List<String>> getServerNamesPerNode() {
        HashMap<WasNodeAgent, List<String>> serverNamesPerNode = new HashMap<WasNodeAgent, List<String>>();
        for (WasManagedServer server : this.servers) {
            WasNodeAgent node = server.getNode();
            ArrayList<String> serverNames = (ArrayList<String>)serverNamesPerNode.get(node);
            if (serverNames == null) {
                serverNames = new ArrayList<String>();
                serverNamesPerNode.put(node, serverNames);
            }
            serverNames.add(server.getName());
        }
        return serverNamesPerNode;
    }

    @Override
    public Collection<WasNodeAgent> getNodes() {
        HashSet<WasNodeAgent> nodes = new HashSet<WasNodeAgent>();
        for (WasManagedServer server : this.servers) {
            nodes.add(server.getNode());
        }
        return nodes;
    }

    public static String getLogPathForMember(String memberServerName, String logPrefix) {
        if (StringUtils.isBlank((String)logPrefix)) {
            return logPrefix;
        }
        return logPrefix + memberServerName + ".txt";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WasCluster discover(Map<String, Object> info, ChangePlan cp) {
        return this;
    }

    public WasCluster discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }

    @Override
    public String getWasConfigIdType() {
        return "ServerCluster";
    }

    @Override
    public String getWasTargetType() {
        return "cluster";
    }

    @Override
    public String getShortTypeDescription() {
        return "cluster";
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Map<WasNodeAgent, List<String>> serverNamesPerNode = this.getServerNamesPerNode();
        ArrayList<String> applicationManagerObjectNames = new ArrayList<String>();
        for (Map.Entry<WasNodeAgent, List<String>> each : serverNamesPerNode.entrySet()) {
            WasNodeAgent eachNode = each.getKey();
            List<String> eachNodeServerNames = each.getValue();
            for (String eachServerName : eachNodeServerNames) {
                applicationManagerObjectNames.add("cell=" + this.cell.getCellName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process=" + eachServerName + ",*");
            }
        }
        return applicationManagerObjectNames;
    }
}

