/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.mapper.JeeWebArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.CreateWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.StartWasUnmanagedServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasUnmanagedServerStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasFileServingEnabledStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasVirtualHostAliasesStep;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarToWasUnmanagedServerMapper
extends JeeWebArtifactToWasTargetMapper<War, WasWarMapping, WasUnmanagedServer> {
    public WarToWasUnmanagedServerMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected void generateAdditionStepsForAddedMapping(War ear, WasWarMapping mapping, WasUnmanagedServer target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = WarToWasUnmanagedServerMapper.getWebservers(mapping);
        steps.add(new CreateWasVirtualHostStep(target.getCell(), ear.getName()));
        steps.add(new UpdateWasVirtualHostAliasesStep(target.getCell(), ear.getName(), this.validateAndGetVirtualHostFromMapping(mapping)));
        steps.add(new StopWasUnmanagedServerStep(target));
        steps.add(new StartWasUnmanagedServerStep(target));
        this.generateDeployStep(ear, mapping, target, webservers, steps);
        List<WarsWebserversVirtualHostMapping> fileServingEnabledPerWars = this.getFileServingEnabledPerWars(mapping);
        for (WarsWebserversVirtualHostMapping warsWebserversVHMapping : fileServingEnabledPerWars) {
            if (warsWebserversVHMapping.getFileServing() == null || warsWebserversVHMapping.getFileServing() == WasFileServing.DO_NOT_OVERRIDE) continue;
            steps.add(new UpdateWasFileServingEnabledStep((NamedDeployableArtifact)ear, target, warsWebserversVHMapping.getWarName(), warsWebserversVHMapping.getFileServing()));
        }
        for (WasManagedApacheHttpdServer eachWebServer : webservers) {
            this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, this.validateAndGetVirtualHostFromMapping(mapping));
        }
    }

    @Override
    protected void generateDeletionStepsForDeletedMapping(War ear, WasWarMapping mapping, WasUnmanagedServer target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = WarToWasUnmanagedServerMapper.getWebservers(mapping);
        this.generateStopStep(ear, target, mapping, steps);
        this.generateUndeployStep(ear, target, mapping, steps);
        steps.add(new DestroyWasVirtualHostStep(target.getCell(), ear.getName()));
        steps.add(new StopWasUnmanagedServerStep(target));
        steps.add(new StartWasUnmanagedServerStep(target));
        for (WasManagedApacheHttpdServer eachWebServer : webservers) {
            this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, this.validateAndGetVirtualHostFromMapping(mapping));
        }
    }

    @Override
    protected void generateModificationStepsForModifiedMapping(War oldMappingSource, WasWarMapping oldVersionOfModifiedMapping, WasUnmanagedServer oldMappingTarget, War newMappingSource, WasWarMapping newVersionOfModifiedMapping, WasUnmanagedServer newMappingTarget, List<Step> steps) {
        boolean mappingSourceChanged = !oldMappingSource.equals((Object)newMappingSource);
        Set<WasManagedApacheHttpdServer> webservers = WarToWasUnmanagedServerMapper.getWebservers(newVersionOfModifiedMapping);
        if (mappingSourceChanged) {
            this.generateStopStep(oldMappingSource, oldMappingTarget, oldVersionOfModifiedMapping, steps);
            this.generateUndeployStep(oldMappingSource, oldMappingTarget, oldVersionOfModifiedMapping, steps);
        }
        if (!oldVersionOfModifiedMapping.getVirtualHost().equals(newVersionOfModifiedMapping.getVirtualHost())) {
            steps.add(new StopWasUnmanagedServerStep(oldMappingTarget));
            steps.add(new DestroyWasVirtualHostStep(oldMappingTarget.getCell(), oldMappingSource.getName()));
            steps.add(new CreateWasVirtualHostStep(newMappingTarget.getCell(), newMappingSource.getName()));
            steps.add(new UpdateWasVirtualHostAliasesStep(newMappingTarget.getCell(), newMappingSource.getName(), this.validateAndGetVirtualHostFromMapping(newVersionOfModifiedMapping)));
            steps.add(new StartWasUnmanagedServerStep(newMappingTarget));
        }
        if (mappingSourceChanged) {
            this.generateDeployStep(newMappingSource, newVersionOfModifiedMapping, newMappingTarget, webservers, steps);
            List<WarsWebserversVirtualHostMapping> fileServingEnabledPerWars = this.getFileServingEnabledPerWars(newVersionOfModifiedMapping);
            for (WarsWebserversVirtualHostMapping warsWebserversVHMapping : fileServingEnabledPerWars) {
                if (warsWebserversVHMapping.getFileServing() == null || warsWebserversVHMapping.getFileServing() == WasFileServing.DO_NOT_OVERRIDE) continue;
                steps.add(new UpdateWasFileServingEnabledStep((NamedDeployableArtifact)newMappingSource, newMappingTarget, warsWebserversVHMapping.getWarName(), warsWebserversVHMapping.getFileServing()));
            }
        }
    }

    @Override
    protected void generateDeployStep(War artifact, WasWarMapping mapping, WasUnmanagedServer server, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationStep(server.getCell(), mapping.getSource(), Collections.singleton(server), webservers, artifact.getName(), mapping.getSharedLibraries(), mapping.getContextRoot(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getResourceEnvironmentEntryReferences(), mapping.getResourceReferences(), mapping.getEjbReferences(), mapping.getSecurityRoleUserGroupMappings()));
    }

    @Override
    protected void generateUndeployStep(War artifact, WasUnmanagedServer cluster, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep(cluster.getCell(), mapping.getSource()));
    }

    @Override
    protected void generateStartStep(War artifact, WasUnmanagedServer server, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasStartApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected void generateStopStep(War artifact, WasUnmanagedServer server, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasStopApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected String getVirtualHostFromMapping(WasWarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasWarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
        m.setContextRoot(m.getSource().getName());
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasWarMapping mapping) {
        return Lists.newArrayList();
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasWarMapping mapping) {
        ArrayList fileServingEnabledPerWars = Lists.newArrayList();
        if (mapping.getFileServing() != null && mapping.getFileServing() != WasFileServing.DO_NOT_OVERRIDE) {
            fileServingEnabledPerWars.add(new WarsWebserversVirtualHostMapping(mapping.getSource().getName() + "." + "war", "", "", "", mapping.getFileServing()));
        }
        return fileServingEnabledPerWars;
    }
}

