/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.sun.istack.internal.Nullable;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasJndiProperties;
import com.xebialabs.deployit.plugin.was.ci.WasJndiPropertiesToWasScopeMapping;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.step.CreateWasStringNameSpaceBindingsStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasStringNameSpaceBindingsStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasJndiPropertiesToWasTargetMapper
extends StepGeneratingMapper<WasJndiProperties, WasJndiPropertiesToWasScopeMapping, WasScope> {
    private final Function<Map.Entry<String, String>, KeyValuePair> fromEntryToKVPair = new Function<Map.Entry<String, String>, KeyValuePair>(){

        public KeyValuePair apply(@Nullable Map.Entry<String, String> from) {
            return new KeyValuePair(from.getKey(), from.getValue());
        }
    };
    private final Function<Map.Entry<String, MapDifference.ValueDifference<String>>, KeyValuePair> fromValueDifferenceToKVPair = new Function<Map.Entry<String, MapDifference.ValueDifference<String>>, KeyValuePair>(){

        public KeyValuePair apply(@Nullable Map.Entry<String, MapDifference.ValueDifference<String>> from) {
            return new KeyValuePair(from.getKey(), (String)from.getValue().rightValue());
        }
    };

    public WasJndiPropertiesToWasTargetMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(WasJndiProperties resource, WasJndiPropertiesToWasScopeMapping newMapping, WasScope target, List<Step> steps) {
        List<KeyValuePair> resolved = this.resolveKeyValuePairs(resource, newMapping);
        KeyValuePair[] pairs = resolved.toArray(new KeyValuePair[resolved.size()]);
        steps.add(new CreateWasStringNameSpaceBindingsStep(target, pairs));
    }

    protected void generateDeletionStepsForDeletedMapping(WasJndiProperties resource, WasJndiPropertiesToWasScopeMapping oldMapping, WasScope target, List<Step> steps) {
        List<KeyValuePair> resolved = this.resolveKeyValuePairs(resource, oldMapping);
        KeyValuePair[] pairs = resolved.toArray(new KeyValuePair[resolved.size()]);
        steps.add(new DestroyWasStringNameSpaceBindingsStep(target, pairs));
    }

    private List<KeyValuePair> resolveKeyValuePairs(WasJndiProperties resource, WasJndiPropertiesToWasScopeMapping mapping) {
        ArrayList resolved = Lists.newArrayList();
        MapDifference difference = Maps.difference((Map)KeyValuePair.toMap(resource.getStringNameSpaceBindings()), (Map)KeyValuePair.toMap(mapping.getKeyValuePairs()));
        resolved.addAll(Lists.transform((List)Lists.newArrayList(difference.entriesOnlyOnRight().entrySet()), this.fromEntryToKVPair));
        resolved.addAll(Lists.transform((List)Lists.newArrayList(difference.entriesOnlyOnLeft().entrySet()), this.fromEntryToKVPair));
        resolved.addAll(Lists.transform((List)Lists.newArrayList(difference.entriesDiffering().entrySet()), this.fromValueDifferenceToKVPair));
        return resolved;
    }
}

