/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.Collection;
import java.util.Map;

public class RetrieveWasUnmanagedServerNameBySoapPortStep
extends WasStepBase {
    private Collection<String> serverNames;
    private WasUnmanagedServer server;

    public RetrieveWasUnmanagedServerNameBySoapPortStep(WasUnmanagedServer server) {
        super(server.getCell());
        this.server = server;
        this.setDescription("Retrieve name of server, corresponding with port " + server.getPort());
    }

    public boolean execute(StepExecutionContext ctx) {
        this.serverNames = (Collection)ctx.getAttribute("WasServer");
        for (String serverName : this.serverNames) {
            ctx.logOutput("Retrieving server name for server " + serverName);
            Map<String, String> soapConnectorProperties = this.cell.getObjectInfoWithSubLevelByTypeAndName(ctx, "/Server:" + serverName, "SOAPConnector", "SOAP_CONNECTOR_ADDRESS");
            if (this.server.getPort() != Integer.parseInt(soapConnectorProperties.get("port"))) continue;
            this.server.setName(serverName);
            return true;
        }
        ctx.logError("Unable to find server name in Cell configuration for the UnmanagedWebSphereServer listening on SOAP port " + this.server.getPort());
        return false;
    }
}

