/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.mapper.WasModificationSupportingStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.step.CopyWasWebServerPluginConfigurationStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.GenerateWasUnManagedWebServerPluginConfigurationStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasFileServingEnabledStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasVirtualHostAliasesStep;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JeeWebArtifactToWasTargetMapper<S extends NamedDeployableArtifact, M extends Mapping<? super S, ? super T>, T extends WasTarget>
extends WasModificationSupportingStepGeneratingMapper<S, M, T> {
    public JeeWebArtifactToWasTargetMapper(Change<Deployment> change, boolean applyDefaultMapping) {
        super(change, applyDefaultMapping);
    }

    protected void generateAdditionStepsForAddedMapping(S ear, M mapping, T target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = JeeWebArtifactToWasTargetMapper.getWebservers(mapping);
        String virtualHostAlias = this.validateAndGetVirtualHostFromMapping(mapping);
        boolean isAppVirtualHostRequired = this.getAppVirtualHostRequired(mapping);
        if (isAppVirtualHostRequired) {
            steps.add(new CreateWasVirtualHostStep(target.getCell(), ear.getName()));
            steps.add(new UpdateWasVirtualHostAliasesStep(target.getCell(), ear.getName(), virtualHostAlias));
        }
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) continue;
            steps.add(new CreateWasVirtualHostStep(target.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, ear.getName())));
            steps.add(new UpdateWasVirtualHostAliasesStep(target.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, ear.getName()), this.getVirtualHostAliasFromMappingOrDefault(eachMapping, virtualHostAlias)));
        }
        this.generateDeployStep(ear, mapping, target, webservers, steps);
        List<WarsWebserversVirtualHostMapping> fileServingEnabledPerWars = this.getFileServingEnabledPerWars(mapping);
        for (WarsWebserversVirtualHostMapping warsWebserversVHMapping : fileServingEnabledPerWars) {
            if (warsWebserversVHMapping.getFileServing() == null || warsWebserversVHMapping.getFileServing() == WasFileServing.DO_NOT_OVERRIDE) continue;
            steps.add(new UpdateWasFileServingEnabledStep((NamedDeployableArtifact)ear, (WasTarget)target, warsWebserversVHMapping.getWarName(), warsWebserversVHMapping.getFileServing()));
        }
        if (isAppVirtualHostRequired) {
            this.associateVirtualHostWithWebServers(webservers, virtualHostAlias);
        }
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getNewRevision()).getTarget(), eachMapping.getWebserver());
            this.associateVirtualHostWithWebServers(webServersFromEnvironment, this.getVirtualHostAliasFromMappingOrDefault(eachMapping, virtualHostAlias));
        }
    }

    protected void associateVirtualHostWithWebServers(Set<WasManagedApacheHttpdServer> webservers, String virtualHostAlias) {
        for (WasManagedApacheHttpdServer eachWebServer : webservers) {
            this.associateVirtualHostWithWebServer(this.virtualHostsPerWebServer, eachWebServer, virtualHostAlias);
        }
    }

    protected void generateDeletionStepsForDeletedMapping(S ear, M mapping, T target, List<Step> steps) {
        Set<WasManagedApacheHttpdServer> webservers = JeeWebArtifactToWasTargetMapper.getWebservers(mapping);
        this.generateStopStep(ear, target, mapping, steps);
        this.generateUndeployStep(ear, target, mapping, steps);
        boolean isAppVirtualHostRequired = this.getAppVirtualHostRequired(mapping);
        if (isAppVirtualHostRequired) {
            steps.add(new DestroyWasVirtualHostStep(target.getCell(), ear.getName()));
        }
        String virtualHostAlias = this.validateAndGetVirtualHostFromMapping(mapping);
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) continue;
            steps.add(new DestroyWasVirtualHostStep(target.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, ear.getName())));
        }
        if (isAppVirtualHostRequired) {
            this.associateVirtualHostWithWebServers(webservers, virtualHostAlias);
        }
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getOldRevision()).getTarget(), eachMapping.getWebserver());
            this.associateVirtualHostWithWebServers(webServersFromEnvironment, this.getVirtualHostAliasFromMappingOrDefault(eachMapping, virtualHostAlias));
        }
    }

    public void generateStartSteps(List<Step> steps) {
        for (Pair m : this.modifiedMappings) {
            Mapping newM = (Mapping)m.getSecond();
            this.generateStartStep((NamedDeployableArtifact)newM.getSource(), (WasTarget)newM.getTarget(), newM, steps);
        }
        for (Pair m : this.addedMappings) {
            this.generateStartStep((NamedDeployableArtifact)m.getSource(), (WasTarget)m.getTarget(), m, steps);
        }
    }

    protected void generateModificationStepsForModifiedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, S newMappingSource, M newVersionOfModifiedMapping, T newMappingTarget, List<Step> steps) {
        String oldVirtualHost = null;
        String newVirtualHost = null;
        if (WasEarMapping.class.isInstance(oldVersionOfModifiedMapping)) {
            oldVirtualHost = ((WasEarMapping)((Object)WasEarMapping.class.cast(oldVersionOfModifiedMapping))).getVirtualHost();
            newVirtualHost = ((WasEarMapping)((Object)WasEarMapping.class.cast(newVersionOfModifiedMapping))).getVirtualHost();
        } else {
            oldVirtualHost = ((WasWarMapping)((Object)WasWarMapping.class.cast(oldVersionOfModifiedMapping))).getVirtualHost();
            newVirtualHost = ((WasWarMapping)((Object)WasWarMapping.class.cast(newVersionOfModifiedMapping))).getVirtualHost();
        }
        boolean mappingSourceChanged = !oldMappingSource.equals(newMappingSource);
        boolean virtualHostChanged = !oldVirtualHost.equals(newVirtualHost);
        boolean virtualHostChangedForWarsInsideEar = false;
        Set<WasManagedApacheHttpdServer> oldWebservers = JeeWebArtifactToWasTargetMapper.getWebservers(oldVersionOfModifiedMapping);
        this.generateStopStep(oldMappingSource, oldMappingTarget, oldVersionOfModifiedMapping, steps);
        if (mappingSourceChanged) {
            this.generateUndeployStep(oldMappingSource, oldMappingTarget, oldVersionOfModifiedMapping, steps);
        }
        if (virtualHostChanged) {
            steps.add(new DestroyWasVirtualHostStep(oldMappingTarget.getCell(), oldMappingSource.getName()));
        }
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(oldVersionOfModifiedMapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) continue;
            virtualHostChangedForWarsInsideEar = true;
            steps.add(new DestroyWasVirtualHostStep(oldMappingTarget.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, oldMappingSource.getName())));
        }
        String oldVirtualHostAlias = this.validateAndGetVirtualHostFromMapping(oldVersionOfModifiedMapping);
        this.associateVirtualHostWithWebServers(oldWebservers, oldVirtualHostAlias);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getOldRevision()).getTarget(), eachMapping.getWebserver());
            this.associateVirtualHostWithWebServers(webServersFromEnvironment, this.getVirtualHostAliasFromMappingOrDefault(eachMapping, oldVirtualHostAlias));
        }
        if (virtualHostChanged || virtualHostChangedForWarsInsideEar) {
            for (WasNodeAgent eachNode : oldMappingTarget.getNodes()) {
                steps.add(new SynchronizeWasNodeStep(eachNode));
            }
        }
        if (virtualHostChanged) {
            steps.add(new CreateWasVirtualHostStep(newMappingTarget.getCell(), newMappingSource.getName()));
            steps.add(new UpdateWasVirtualHostAliasesStep(newMappingTarget.getCell(), newMappingSource.getName(), this.validateAndGetVirtualHostFromMapping(newVersionOfModifiedMapping)));
        }
        List<WarsWebserversVirtualHostMapping> newWebserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(newVersionOfModifiedMapping);
        for (WarsWebserversVirtualHostMapping eachMapping : newWebserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) continue;
            virtualHostChangedForWarsInsideEar = true;
            steps.add(new CreateWasVirtualHostStep(newMappingTarget.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, newMappingSource.getName())));
            steps.add(new UpdateWasVirtualHostAliasesStep(newMappingTarget.getCell(), this.getVirtualHostFromMappingOrDefault(eachMapping, newMappingSource.getName()), this.getVirtualHostAliasFromMappingOrDefault(eachMapping, newVirtualHost)));
        }
        Set<WasManagedApacheHttpdServer> newWebservers = JeeWebArtifactToWasTargetMapper.getWebservers(newVersionOfModifiedMapping);
        String newVirtualHostAlias = this.validateAndGetVirtualHostFromMapping(newVersionOfModifiedMapping);
        this.associateVirtualHostWithWebServers(newWebservers, newVirtualHostAlias);
        for (WarsWebserversVirtualHostMapping eachMapping : newWebserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getNewRevision()).getTarget(), eachMapping.getWebserver());
            this.associateVirtualHostWithWebServers(webServersFromEnvironment, this.getVirtualHostAliasFromMappingOrDefault(eachMapping, newVirtualHostAlias));
        }
        if (mappingSourceChanged) {
            this.generateDeployStep(newMappingSource, newVersionOfModifiedMapping, newMappingTarget, newWebservers, steps);
            List<WarsWebserversVirtualHostMapping> fileServingEnabledPerWars = this.getFileServingEnabledPerWars(newVersionOfModifiedMapping);
            for (WarsWebserversVirtualHostMapping warsWebserversVHMapping : fileServingEnabledPerWars) {
                if (warsWebserversVHMapping.getFileServing() == null || warsWebserversVHMapping.getFileServing() == WasFileServing.DO_NOT_OVERRIDE) continue;
                steps.add(new UpdateWasFileServingEnabledStep((NamedDeployableArtifact)newMappingSource, (WasTarget)newMappingTarget, warsWebserversVHMapping.getWarName(), warsWebserversVHMapping.getFileServing()));
            }
        }
        if (virtualHostChanged || virtualHostChangedForWarsInsideEar) {
            for (WasNodeAgent eachNode : newMappingTarget.getNodes()) {
                steps.add(new SynchronizeWasNodeStep(eachNode));
            }
        }
    }

    public void generateAndCopyPluginSteps(List<Step> steps) {
        for (Pair m : this.modifiedMappings) {
            Mapping newM = (Mapping)m.getSecond();
            Set<WasUnManagedApacheHttpdServer> webservers = this.getUnManagedWebservers(newM);
            for (WasUnManagedApacheHttpdServer wasUnManagedApacheHttpdServer : webservers) {
                this.generateAndCopyPluginSteps(wasUnManagedApacheHttpdServer, steps);
            }
        }
        for (Pair m : this.addedMappings) {
            Set<WasUnManagedApacheHttpdServer> webservers = this.getUnManagedWebservers(m);
            for (WasUnManagedApacheHttpdServer wasUnManagedApacheHttpdServer : webservers) {
                this.generateAndCopyPluginSteps(wasUnManagedApacheHttpdServer, steps);
            }
        }
    }

    protected static Set<WasManagedApacheHttpdServer> getWebservers(Mapping<?, ?> mapping) {
        Set<WasManagedApacheHttpdServer> webservers = mapping instanceof WasEarMapping ? ((WasEarMapping)mapping).getWebservers() : (mapping instanceof WasWarMapping ? ((WasWarMapping)mapping).getWebservers() : Collections.emptySet());
        return webservers;
    }

    protected Set<WasUnManagedApacheHttpdServer> getUnManagedWebservers(M mapping) {
        HashSet unManagedWebservers = Sets.newHashSet();
        Set<WasManagedApacheHttpdServer> allWebservers = JeeWebArtifactToWasTargetMapper.getWebservers(mapping);
        for (WasManagedApacheHttpdServer apacheHttpdServer : allWebservers) {
            if (!(apacheHttpdServer instanceof WasUnManagedApacheHttpdServer)) continue;
            unManagedWebservers.add((WasUnManagedApacheHttpdServer)apacheHttpdServer);
        }
        List<WarsWebserversVirtualHostMapping> newWebserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : newWebserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getNewRevision()).getTarget(), eachMapping.getWebserver());
            for (WasManagedApacheHttpdServer wasManagedApacheHttpdServer : webServersFromEnvironment) {
                if (!(wasManagedApacheHttpdServer instanceof WasUnManagedApacheHttpdServer)) continue;
                unManagedWebservers.add((WasUnManagedApacheHttpdServer)wasManagedApacheHttpdServer);
            }
        }
        return unManagedWebservers;
    }

    protected String validateAndGetVirtualHostFromMapping(M mapping) {
        String vhost = this.getVirtualHostFromMapping(mapping);
        if (StringUtils.isBlank((String)vhost)) {
            throw new ResolutionException("Property \"virtualHost\" is not set on mapping " + mapping);
        }
        return vhost;
    }

    protected String getVirtualHostAliasFromMappingOrDefault(WarsWebserversVirtualHostMapping eachMapping, String defaultVirtualHostAlias) {
        if (StringUtils.isBlank((String)eachMapping.getVirtualHostAlias())) {
            return defaultVirtualHostAlias;
        }
        return eachMapping.getVirtualHostAlias();
    }

    protected String getVirtualHostFromMappingOrDefault(WarsWebserversVirtualHostMapping eachMapping, String defaultVirtualHost) {
        if (StringUtils.isBlank((String)eachMapping.getVirtualHost())) {
            return defaultVirtualHost;
        }
        return eachMapping.getVirtualHost();
    }

    protected Set<WasManagedApacheHttpdServer> getWebServerFromEnvironment(Environment env, String webServerNames) {
        String[] serversArray;
        HashSet webserversFromEnvironment = Sets.newHashSet();
        for (String serverNameFromMapping : serversArray = StringUtils.split((String)webServerNames, (String)";")) {
            WasManagedApacheHttpdServer webserverFromEnvironment = this.getWebserverFromEnvironmentWithLabel(env, serverNameFromMapping);
            webserversFromEnvironment.add(webserverFromEnvironment);
        }
        return webserversFromEnvironment;
    }

    private WasManagedApacheHttpdServer getWebserverFromEnvironmentWithLabel(Environment env, String webserverName) {
        Set webserversInEnvironment = env.getMembersOfType(WasManagedApacheHttpdServer.class);
        for (WasManagedApacheHttpdServer eachServer : webserversInEnvironment) {
            if (!eachServer.getLabel().equals(webserverName)) continue;
            return eachServer;
        }
        throw new ResolutionException("No webserver with label '" + webserverName + "' found in the environment");
    }

    protected void generateAndCopyPluginSteps(WasUnManagedApacheHttpdServer webserver, List<Step> steps) {
        steps.add(new GenerateWasUnManagedWebServerPluginConfigurationStep(webserver));
        steps.add(new CopyWasWebServerPluginConfigurationStep(webserver));
    }

    protected List<WarsWebserversVirtualHostMapping> getUpdatedWebserversMapping(M mapping) {
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelMappingPresent()) continue;
            Set<WasManagedApacheHttpdServer> webServersFromEnvironment = this.getWebServerFromEnvironment(((Deployment)this.change.getNewRevision()).getTarget(), eachMapping.getWebserver());
            eachMapping.setWebservers(webServersFromEnvironment);
        }
        return webserversAndVirtualHostPerWars;
    }

    protected boolean getAppVirtualHostRequired(M mapping) {
        boolean mappingRequired = true;
        List<WarsWebserversVirtualHostMapping> webserversAndVirtualHostPerWars = this.getWebserversAndVirtualHostPerWar(mapping);
        for (WarsWebserversVirtualHostMapping eachMapping : webserversAndVirtualHostPerWars) {
            if (!eachMapping.isWarLevelVirtualHostMappingPresent()) {
                return true;
            }
            mappingRequired = false;
        }
        return mappingRequired;
    }

    protected abstract void generateStartStep(S var1, T var2, M var3, List<Step> var4);

    protected abstract void generateStopStep(S var1, T var2, M var3, List<Step> var4);

    protected abstract String getVirtualHostFromMapping(M var1);

    protected abstract List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(M var1);

    protected abstract List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(M var1);

    protected abstract void generateDeployStep(S var1, M var2, T var3, Collection<WasManagedApacheHttpdServer> var4, List<Step> var5);

    protected abstract void generateUndeployStep(S var1, T var2, M var3, List<Step> var4);
}

