/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasDataSource;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class CreateWasDataSourceStep
extends WasStepBase {
    public static final String CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-datasource.py";
    private WasDataSource wasDataSource;
    private WasScope target;

    public CreateWasDataSourceStep(WasDataSource wasDataSource, WasScope target) {
        super(target.getCell());
        this.wasDataSource = wasDataSource;
        this.target = target;
        if ((wasDataSource.getUrl() == null || "".equals(wasDataSource.getUrl())) && (wasDataSource.getDatabaseName() == null || "".equals(wasDataSource.getDatabaseName()) || wasDataSource.getDatabaseServerName() == null || "".equals(wasDataSource.getDatabaseServerName()) || wasDataSource.getDatabasePortNumber() <= 0)) {
            throw new ResolutionException("You have not specified a URL for non-Oracle datasource " + wasDataSource.getLabel() + ". This requires specifying all three properties databaseName, databaseServerName, and databasePortNumber");
        }
        this.setDescription("Create datasource " + (Object)((Object)wasDataSource) + " on " + target.getShortTypeDescription() + " " + target);
    }

    public boolean execute(StepExecutionContext ctx) {
        return this.executeWsadminJythonScriptResource(ctx, CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH, this.wasDataSource.getName(), this.wasDataSource.getDescription(), this.wasDataSource.getJndiName(), this.wasDataSource.getProvider(), this.wasDataSource.getDataStoreHelperClass(), this.wasDataSource.getUrl(), this.wasDataSource.getDatabaseName(), this.wasDataSource.getDatabaseServerName(), Integer.toString(this.wasDataSource.getDatabasePortNumber()), this.wasDataSource.getUsername(), this.wasDataSource.getPassword(), Integer.toString(this.wasDataSource.getStatementCacheSize()), this.cell.getCellName(), this.target.getWasConfigIdType(), this.target.getName(), this.target.getShortTypeDescription()) == 0;
    }

    public WasDataSource getWasDataSource() {
        return this.wasDataSource;
    }

    public WasScope getTarget() {
        return this.target;
    }
}

