/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.was.ci.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Destroys <a href="http://publib.boulder.ibm.com/infocenter/wasinfo/v6r1/index.jsp?topic=/com.ibm.websphere.javadoc.doc/configdoc/namebindings/StringNameSpaceBinding.html"
 * > String name space bindings</a> in a {@link WasDeploymentManager}.
 */
@SuppressWarnings("serial")
public class DestroyWasStringNameSpaceBindingsStep extends WasStepBase {

	protected static final String DESTROY_STRING_NAMESPACE_BINDING_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-string-namespace-bindings.py";

	private static final String SERVER = "Server";

	private static final String CLUSTER = "Cluster";

	private static final String NODE = "Node";

	private static final String CELL = "Cell";

	protected KeyValuePair[] keyValuePairs;

	private WasScope scopeTarget;
	private String scope;

	public DestroyWasStringNameSpaceBindingsStep(WasScope scopeTarget, KeyValuePair... pairs) {
		this(scopeTarget,"unknown",pairs);
	}

	public DestroyWasStringNameSpaceBindingsStep(WasScope scopeTarget, String resourceLabelName, KeyValuePair... pairs) {
		super(scopeTarget.getCell());
		this.scopeTarget = scopeTarget;
		this.keyValuePairs = pairs;
		this.scope = getScopeDescription(scopeTarget);
		setDescription("Destroy JNDI string name space bindings (#"+(this.keyValuePairs != null ? this.keyValuePairs.length : "empty")+") in " + scopeTarget + " from "+resourceLabelName+" (at scope: " + scope + ")");
	}

	private String getScopeDescription(WasScope scopeTarget) {
		String scope = null;
		if (scopeTarget instanceof WasNode && !(scopeTarget instanceof WasUnmanagedServer)) {
			scope = NODE;
		} else if (scopeTarget instanceof WasCluster) {
			scope = CLUSTER;
		} else if (scopeTarget instanceof WasServer || (scopeTarget instanceof WasUnmanagedServer)) {
			scope = SERVER;
		} else if (scopeTarget instanceof WasCell && !(scopeTarget instanceof WasUnmanagedServer)) {
			scope = CELL;
		}
		return scope;
	}

	public boolean execute(StepExecutionContext ctx) {
		List<String> args = new ArrayList<String>();
		args.add(scope);
		if (scope.equals(CELL)) {
			args.add(cell.getCellName());
		} else if (scope.equals(NODE)) {
			WasNode wasNode = (WasNode) scopeTarget;
			args.add(cell.getCellName());
			args.add(wasNode.getNodeName());
		} else if (scope.equals(CLUSTER)) {
			WasCluster cluster = (WasCluster) scopeTarget;
			args.add(cluster.getName());
		} else if (scope.equals(SERVER)) {
			WasServer server = (WasServer) scopeTarget;
			args.add(cell.getCellName());
			args.add(server.getNodeName());
			args.add(server.getName());
		}
		for (KeyValuePair each : keyValuePairs) {
			args.add(each.getKey());
		}
		return (executeWsadminJythonScriptResource(ctx, DESTROY_STRING_NAMESPACE_BINDING_SCRIPT_RESOURCE_PATH, args.toArray(new String[args.size()])) == 0);
	}

	public KeyValuePair[] getKeyValuePairs() {
		return keyValuePairs;
	}
}