/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Modifies the properties of a single member (determined by memberNumber) of a {@link WasCluster} on a {@link WasNodeAgent}
 */
@SuppressWarnings("serial")
public class ModifyWasServerStep extends WasStepBase {

	protected static final String MODIFY_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "configure-server.py";

	protected WasManagedServer server;

	public ModifyWasServerStep(WasManagedServer server) {
		super(server.getCell());
		this.server = server;
		setDescription("Configure server " + server + " on node " + server.getNode() + " in cell " + cell);
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, MODIFY_SERVER_SCRIPT_RESOURCE_PATH, getArgs(server.getNode().getName(), server.getName()).toArray(
				new String[] {})) == 0);
	}

	private List<String> getArgs(String nodeName, String serverName) {

		List<String> args = new ArrayList<String>();
		args.add(cell.getCellName());
		args.add(nodeName);
		args.add(serverName);

		addConfigureServerArgument("classpath", server.getClasspath(), args);
		addConfigureServerArgument("bootclasspath", server.getBootClasspath(), args);
		addConfigureServerArgument("initheapsize", server.getInitHeapSize(), args);
		addConfigureServerArgument("maxheapsize", server.getMaxHeapSize(), args);
		addConfigureServerArgument("jvmargs", server.getJvmArguments(), args);
		addConfigureServerArgument("disablejit", Boolean.toString(server.getDisableJit()), args);

		if (server.getApplicationClassLoaderPolicyAndMode() != null) {
			switch (server.getApplicationClassLoaderPolicyAndMode()) {
			case MULTIPLE:
				args.add("applicationclassloaderpolicy");
				args.add("MULTIPLE");
				break;
			case SINGLE_PARENT_FIRST:
				args.add("applicationclassloaderpolicy");
				args.add("SINGLE");
				args.add("applicationclassloadingmode");
				args.add("PARENT_FIRST");
				break;
			case SINGLE_PARENT_LAST:
				args.add("applicationclassloaderpolicy");
				args.add("SINGLE");
				args.add("applicationclassloadingmode");
				args.add("PARENT_LAST");
				break;
			}
		}

		addConfigureServerArgument("workdir", server.getWorkingDir(), args);
		addConfigureServerArgument("umask", server.getUmask(), args);

		addConfigureServerArgument("stdoutlog", getLogPathForMember(serverName, server.getStdOut()), args);
		addConfigureServerArgument("stderrlog", getLogPathForMember(serverName, server.getStdErr()), args);
		addConfigureServerArgument("jvmstdoutlog", getLogPathForMember(serverName, server.getJvmStdOut()), args);
		addConfigureServerArgument("jvmstderrlog", getLogPathForMember(serverName, server.getJvmStdErr()), args);

		addConfigureServerArgument("servletcaching", Boolean.toString(server.getServletCaching()), args);
		addConfigureServerArgument("sessmaxinmem", server.getMaximumSessionsInMemory(), args);
		addConfigureServerArgument("sesstimeout", server.getSessionTimeout(), args);
		addConfigureServerArgument("sesscookieenabled", Boolean.toString(server.getEnableSessionCookies()), args);
		if (StringUtils.isNotBlank(server.getCookieName())) {
			args.add("sesscookie");
			args.add(StringUtils.defaultIfEmpty(server.getCookieName(), "JSESSIONID"));
			args.add(StringUtils.defaultString(server.getCookieDomain()));
			args.add(StringUtils.defaultIfEmpty(server.getCookiePath(), "/"));
		}

		for (KeyValuePair pair : server.getEnvironmentEntries()) {
			addConfigureServerArgument("environment", pair, args);
		}

		return args;

	}

	private void addConfigureServerArgument(final String propname, final KeyValuePair pair, final List<String> args) {
		args.add(propname + "_" + pair.getKey());
		args.add(pair.getValue());
	}

	private static String getLogPathForMember(String serverName, String logPrefix) {
		if (StringUtils.isBlank(logPrefix)) {
			return logPrefix;
		} else {
			return logPrefix + serverName + ".txt";
		}
	}

	private static void addConfigureServerArgument(String propname, String propvalue, String suffix, List<String> args) {
		if (StringUtils.isNotBlank(propvalue)) {
			args.add(propname);
			if (suffix != null) {
				args.add(propvalue + suffix);
			} else {
				args.add(propvalue);
			}
		}
	}

	private static void addConfigureServerArgument(String propname, String propvalue, List<String> args) {
		addConfigureServerArgument(propname, propvalue, null, args);
	}

	private static void addConfigureServerArgument(String propname, int propvalue, List<String> args) {
		if (propvalue != 0) {
			args.add(propname);
			args.add(Integer.toString(propvalue));
		}
	}

}
