/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderMode;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasWarClassLoaderMapping;

public class WasEarUtils {

	public static List<String> getWarsInEar(Ear ear) {
		List<String> wars = new ArrayList<String>();
		NodeList warNodes = WasUtils.getNodesWithTag("web", ear, "META-INF/application.xml");
		if (warNodes != null) {
			for (int i = 0; i < warNodes.getLength(); i++) {
				Element warNode = (Element) warNodes.item(i);
				String name = WasUtils.findName(warNode, "web-uri");
				if (name != null) {
					wars.add(name);
				}
			}
		}
		return wars;
	}

	public static Set<String> getSecurityRolesInEar(Ear ear) {
		Set<String> securityRoles = new HashSet<String>();
		NodeList warNodes = WasUtils.getNodesWithTag("web", ear, "META-INF/application.xml");
		if (warNodes != null) {
			for (int i = 0; i < warNodes.getLength(); i++) {
				Element warNode = (Element) warNodes.item(i);
				String name = WasUtils.findName(warNode, "web-uri");
				if (name != null) {
					NodeList securityRolesList = getNodesWithTagInJarEntry("security-role", ear, name);
					if (securityRolesList != null) {
						for (int j = 0; j < securityRolesList.getLength(); j++) {
							Element securityRole = (Element) securityRolesList.item(j);
							String roleName = WasUtils.findName(securityRole, "role-name");
							if (roleName != null) {
								securityRoles.add(roleName);
							}
						}
					}
				}
			}
		}
		return securityRoles;
	}

	private static NodeList getNodesWithTagInJarEntry(String tag, Ear ear, String jarEntryName) {
		// look into the web.xml file
		try {
			JarFile jarFile = new JarFile(new File(ear.getLocation()));
			JarEntry jarEntry = jarFile.getJarEntry(jarEntryName);
			if (jarEntry != null) {
				InputStream is = jarFile.getInputStream(jarEntry);
				JarInputStream inputStream = new JarInputStream(is);
				JarEntry jarEntryWebXml = null;
				while (true) {
					jarEntryWebXml = inputStream.getNextJarEntry();
					if (jarEntryWebXml == null) {
						break;
					} else if (jarEntryWebXml.getName().endsWith("web.xml")) {
						break;
					} else {
						jarEntryWebXml = null;
					}
				}
				if (jarEntryWebXml == null) {
					return null;
				}
				DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
				DocumentBuilder db = dbf.newDocumentBuilder();
				WasUtils.disableDtdValidation(db);
				Document doc = db.parse(new InputSource(inputStream));
				NodeList resourceRefNodes = doc.getElementsByTagName(tag);
				inputStream.close();
				is.close();
				jarFile.close();
				return resourceRefNodes;
			} else {
				return null;
			}
		} catch (IOException e) {
			throw new RuntimeException("Ear file not found for Ear named " + ear.getName());
		} catch (ParserConfigurationException e) {
			throw new RuntimeException("Parser configuration Exception while trying to parse application.xml for Ear named " + ear.getName());
		} catch (SAXException e) {
			throw new RuntimeException("Parser Exception while parsing web.xml for Ear named " + ear.getName());
		}
	}

	public static List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings(Ear source) {
		List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappingList = Lists.newArrayList();
		Set<String> securityroles = getSecurityRolesInEar(source);
		for (String roleName : securityroles) {
			SecurityRoleUserGroupMappings securityRoleUserGroupMappings = new SecurityRoleUserGroupMappings(roleName, "", "");
			securityRoleUserGroupMappingList.add(securityRoleUserGroupMappings);
		}
		return securityRoleUserGroupMappingList;
	}

	public static List<WarsWebserversVirtualHostMapping> getWarsWebserversMapping(Ear source) {
		List<WarsWebserversVirtualHostMapping> webserversVHMappings = Lists.newArrayList();
		List<String> wars = getWarsInEar(source);
		for (String war : wars) {
			webserversVHMappings.add(new WarsWebserversVirtualHostMapping(war, "", "", "", WasFileServing.DO_NOT_OVERRIDE));
		}
		return webserversVHMappings;
	}

	public static List<WasWarClassLoaderMapping> getWasWarClassLoaderMappings(Ear Source) {
		List<WasWarClassLoaderMapping> warClassLoaderList = Lists.newArrayList();
		List<String> warNames = getWarsInEar(Source);
		for (String war : warNames) {
			warClassLoaderList.add(new WasWarClassLoaderMapping(war, WasClassLoaderMode.PARENT_FIRST));
		}
		return warClassLoaderList;
	}
}
