/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.mapper.JeeWebArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarToWasServerMapper
extends JeeWebArtifactToWasTargetMapper<War, WasWarMapping, WasManagedServer> {
    public WarToWasServerMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected void generateDeployStep(War artifact, WasWarMapping mapping, WasManagedServer server, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationStep(server.getCell(), mapping.getSource(), Collections.singleton(server), webservers, artifact.getName(), mapping.getSharedLibraries(), mapping.getContextRoot(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getResourceEnvironmentEntryReferences(), mapping.getResourceReferences(), mapping.getEjbReferences(), mapping.getSecurityRoleUserGroupMappings()));
    }

    @Override
    protected void generateUndeployStep(War artifact, WasManagedServer server, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep((WasCell)server.getCell(), mapping.getSource()));
    }

    @Override
    protected void generateStartStep(War artifact, WasManagedServer server, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasStartApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected void generateStopStep(War artifact, WasManagedServer server, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasStopApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected String getVirtualHostFromMapping(WasWarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasWarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
        m.setContextRoot(m.getSource().getName());
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasWarMapping mapping) {
        return Lists.newArrayList();
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasWarMapping mapping) {
        ArrayList fileServingEnabledPerWars = Lists.newArrayList();
        if (mapping.getFileServing() != null && mapping.getFileServing() != WasFileServing.DO_NOT_OVERRIDE) {
            fileServingEnabledPerWars.add(new WarsWebserversVirtualHostMapping(mapping.getSource().getName() + "." + "war", "", "", "", mapping.getFileServing()));
        }
        return fileServingEnabledPerWars;
    }
}

