/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibrary;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class CreateWasSharedLibraryStep
extends WasStepBase {
    public static final String CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-shared-library.py";
    private WasSharedLibrary sharedLibrary;
    private WasScope scopeTarget;
    private String fullClassPath;

    public CreateWasSharedLibraryStep(WasSharedLibrary library, WasScope scopeTarget, String fullClassPath) {
        super(scopeTarget.getCell());
        this.sharedLibrary = library;
        this.scopeTarget = scopeTarget;
        this.fullClassPath = fullClassPath;
        String description = "Create shared library " + library;
        if (scopeTarget instanceof WasNode) {
            WasNode node = (WasNode)scopeTarget;
            description = description + "on Node:" + node.getNodeName();
        } else if (scopeTarget instanceof WasCluster) {
            WasCluster cluster = (WasCluster)scopeTarget;
            description = description + "on Cluster:" + cluster.getName();
        } else if (scopeTarget instanceof WasServer) {
            WasServer server = (WasServer)scopeTarget;
            description = description + "on Server:" + server.getName();
        }
        this.setDescription("Create shared library " + library + " in cell " + scopeTarget.getCell());
    }

    public boolean execute(StepExecutionContext ctx) {
        String targetContainmentPath = this.getTagetContainmentPath();
        return this.executeWsadminJythonScriptResource(ctx, CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH, targetContainmentPath, this.sharedLibrary.getName(), this.fullClassPath) == 0;
    }

    private String getTagetContainmentPath() {
        if (this.scopeTarget instanceof WasNode) {
            WasNode node = (WasNode)this.scopeTarget;
            return "/Node:" + node.getNodeName() + "/";
        }
        if (this.scopeTarget instanceof WasCluster) {
            WasCluster cluster = (WasCluster)this.scopeTarget;
            return "/ServerCluster:" + cluster.getName() + "/";
        }
        if (this.scopeTarget instanceof WasServer) {
            WasServer server = (WasServer)this.scopeTarget;
            return "/Server:" + server.getName() + "/";
        }
        throw new IllegalArgumentException("Wrong wasScopeTarget was used for creating was shared library " + this.scopeTarget.getClass());
    }
}

