/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.ArrayList;

public class CreateWasStringNameSpaceBindingsStep
extends WasStepBase {
    private static final String SERVER = "Server";
    private static final String CLUSTER = "Cluster";
    private static final String NODE = "Node";
    private static final String CELL = "Cell";
    protected static final String CREATE_STRING_NAMESPACE_BINDING_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-string-namespace-bindings.py";
    private KeyValuePair[] keyValuePairs;
    private WasScope scopeTarget;
    private String scope;

    public CreateWasStringNameSpaceBindingsStep(WasScope scopeTarget, KeyValuePair ... pairs) {
        this(scopeTarget, "unknown", pairs);
    }

    public CreateWasStringNameSpaceBindingsStep(WasScope scopeTarget, String resourceLabelName, KeyValuePair ... pairs) {
        super(scopeTarget.getCell());
        this.scopeTarget = scopeTarget;
        this.keyValuePairs = pairs;
        this.scope = this.getScopeDescription(scopeTarget);
        this.setDescription("Create JNDI string name space bindings (#" + (this.keyValuePairs != null ? Integer.valueOf(this.keyValuePairs.length) : "empty") + ") in " + scopeTarget + " from " + resourceLabelName + " (at scope: " + this.scope + ")");
    }

    private String getScopeDescription(WasScope scopeTarget) {
        String scope = null;
        if (scopeTarget instanceof WasNode && !(scopeTarget instanceof WasUnmanagedServer)) {
            scope = NODE;
        } else if (scopeTarget instanceof WasCluster) {
            scope = CLUSTER;
        } else if (scopeTarget instanceof WasServer || scopeTarget instanceof WasUnmanagedServer) {
            scope = SERVER;
        } else if (scopeTarget instanceof WasCell && !(scopeTarget instanceof WasUnmanagedServer)) {
            scope = CELL;
        }
        return scope;
    }

    public boolean execute(StepExecutionContext ctx) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.scope);
        if (this.scope.equals(CELL)) {
            args.add(this.cell.getCellName());
        } else if (this.scope.equals(NODE)) {
            WasNode wasNode = (WasNode)this.scopeTarget;
            args.add(this.cell.getCellName());
            args.add(wasNode.getNodeName());
        } else if (this.scope.equals(CLUSTER)) {
            WasCluster cluster = (WasCluster)this.scopeTarget;
            args.add(cluster.getName());
        } else if (this.scope.equals(SERVER)) {
            WasServer server = (WasServer)this.scopeTarget;
            args.add(this.cell.getCellName());
            args.add(server.getNodeName());
            args.add(server.getName());
        }
        for (KeyValuePair each : this.keyValuePairs) {
            args.add(each.getKey());
            args.add(each.getValue());
        }
        return this.executeWsadminJythonScriptResource(ctx, CREATE_STRING_NAMESPACE_BINDING_SCRIPT_RESOURCE_PATH, args.toArray(new String[args.size()])) == 0;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.keyValuePairs;
    }
}

