/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls;

import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * A factory for Deployit WLS conventions like library location paths etc.
 * <p>
 * <em>TODO:</em> Perhaps make this configurable, e.g. via Spring or the manifest. 
 */
public final class WlsConventions {
	private static final String CUSTOM_LIBRARY_PATTERN = " /opt/bea-10.3/user_projects/domains/%s/application/%s/libraries/";
	private static final String CUSTOM_CONFIGURATION_PATTERN = "/opt/bea-10.3/user_projects/domains/%s/application/%s/configuration/";
	private static final String FILESTORE_PATTERN = "/opt/bea-10.3/user_projects/domains/%s/filestores/";
	
	public static String getCustomLibraryPath(WlsDomain domain, Application app) {
		return String.format(CUSTOM_LIBRARY_PATTERN, ExtendedStringUtils.getQuotedString(domain.getName()),
				ExtendedStringUtils.getQuotedString(app.getLabel()));
	}
	
	public static String getCustomConfigurationPath(WlsDomain domain, Application app) {
		return String.format(CUSTOM_CONFIGURATION_PATTERN, ExtendedStringUtils.getQuotedString(domain.getName()),
				ExtendedStringUtils.getQuotedString(app.getLabel()));
	}	
	
	public static String getFilestorePath(WlsDomain domain) {
		return String.format(FILESTORE_PATTERN, ExtendedStringUtils.getQuotedString(domain.getName()));
	}	
	
}
