#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of Xebialabs Software and Documentation is subject to the Personal
# License Agreement.
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the Xebialabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

modulename = sys.argv.pop(0)
basename = sys.argv.pop(0)
basejndiname = sys.argv.pop(0)
redeliverylimits = sys.argv.pop(0)

servernames = []
jmsservernames = []
module2serversnames = []
while len(sys.argv) >= 3:
    servernames.append(sys.argv.pop(0))
    jmsservernames.append(sys.argv.pop(0))
    module2serversnames.append(sys.argv.pop(0))

#============================#
# Destroy QueueSet           #
#============================# 
def destroyQueueSet(modulename, basename):
  log("Deleting queues: " + basename)
  cd('/')
  for i in range(0, len(jmsservernames)):
    queuename = basename+'_'+str(i+1)
    errorname = basename+'_error_'+str(i+1)
    malformedname = basename+'_malformed_'+str(i+1)
    destroySimpleQueue(modulename, malformedname)
    destroySimpleQueue(modulename, queuename)
    destroySimpleQueue(modulename, errorname)
    cd('/JMSSystemResources/'+modulename+'/JMSResource/'+modulename)

    normal_dist = basename 
    malformed_dist = basename+'_malformed'
    log("Destroying distributed queue: "+normal_dist+" in "+modulename)
    cmo.destroyDistributedQueue( getMBean('DistributedQueues/'+normal_dist) )
    log("Destroying distributed queue: "+malformed_dist+" in "+modulename)
    cmo.destroyDistributedQueue( getMBean('DistributedQueues/'+malformed_dist) )     
  return

#============================#
# Destroy Simple Queue       #
#============================#
def destroySimpleQueue(modulename, queuename) :
  log("Destroying simple queue: "+queuename+" in "+modulename)
  cd('/JMSSystemResources/'+modulename+'/JMSResource/'+modulename)
  queueMBean=getMBean('Queues/'+queuename)
  cmo.destroyQueue(queueMBean)
  return


#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return

connect(user, password, url)
edit()
startEdit()
redeliverylimitList = redeliverylimits.split(',')
destroyQueueSet(modulename, basename)
save()
disconnect('true')
exit('y')
