/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

@ConfigurationItem(description="A WebLogic Domain.", expandable=true, category="middleware")
public class WlsDomain
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=true, description="Name of the WebLogic Domain")
    private String name;
    @ConfigurationItemProperty(required=true, description="Username which is used to login to the WebLogic Domain.")
    private String username;
    @ConfigurationItemProperty(required=true, password=true, description="Password which is used to login to the WebLogic Domain.")
    private String password;
    @ConfigurationItemProperty(required=true, label="WebLogic home", description="The location of the WebLogic Server installation", size=ConfigurationItemProperty.Size.LARGE)
    private String wlHome;
    @ConfigurationItemProperty(required=true, label="Java Home", description="The location of the JDK to use.", size=ConfigurationItemProperty.Size.LARGE)
    private String wlJavaHome;
    @ConfigurationItemProperty(required=false, description="The location of the WebLogic domain. Defaults to '<WebLogicHome>/../user_projects/domains/<Name>'", size=ConfigurationItemProperty.Size.LARGE)
    private String domainHome;
    @ConfigurationItemProperty(required=true, description="Port to be used by the AdminServer for this domain", size=ConfigurationItemProperty.Size.SMALL)
    private int port;
    @ConfigurationItemProperty(required=true, description="The name of the admin server")
    private String adminServerName;
    @ConfigurationItemProperty(required=true, label="Host", description="The host that runs the admin server")
    private Host activeHost;

    public HostSession connectToAdminHost() {
        return HostSessionFactory.getHostSession((Host)this.activeHost);
    }

    public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String ... args) {
        String filesep = this.activeHost.getOperatingSystemFamily().getFileSeparator();
        String wlstFilePath = this.wlJavaHome + filesep + "bin" + filesep + "java";
        String weblogicJarFilePath = this.wlHome + filesep + "server" + filesep + "lib" + filesep + "weblogic.jar";
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(wlstFilePath);
        cmd.add("-classpath");
        cmd.add(weblogicJarFilePath);
        cmd.add("weblogic.WLST");
        cmd.add("-i");
        cmd.add(scriptPath);
        for (String arg : args) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }

    public String getConnectUrl() {
        return this.activeHost.getAddress() + ":" + this.port;
    }

    public Host getActiveHost() {
        return this.activeHost;
    }

    public void setActiveHost(Host activeHost) {
        this.activeHost = activeHost;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getWlHome() {
        return this.wlHome;
    }

    public void setWlHome(String wlHome) {
        this.wlHome = wlHome;
    }

    public String getWlJavaHome() {
        return this.wlJavaHome;
    }

    public void setWlJavaHome(String wlJavaHome) {
        this.wlJavaHome = wlJavaHome;
    }

    public String getDomainHome() {
        return StringUtils.defaultIfEmpty((String)this.domainHome, (String)this.getDefaultDomainHome());
    }

    private String getDefaultDomainHome() {
        String fileSeparator = this.activeHost.getOperatingSystemFamily().getFileSeparator();
        return this.wlHome.substring(0, this.wlHome.lastIndexOf(fileSeparator)) + fileSeparator + "user_projects" + fileSeparator + "domains" + fileSeparator + this.name;
    }

    public void setDomainHome(String domainHome) {
        this.domainHome = domainHome;
    }

    public String getAdminServerName() {
        return this.adminServerName;
    }

    public void setAdminServerName(String adminServerName) {
        this.adminServerName = adminServerName;
    }
}

