/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.WlsConventions;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CreateWlsJmsModuleStep
extends SimpleWlstExecutingStep {
    public static final String SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/wls/step/create-jms-module.py";

    public CreateWlsJmsModuleStep(WlsCluster cluster, WlsJmsModule module) {
        super("Create JMS Module " + (Object)((Object)module) + " for cluster " + (Object)((Object)cluster) + " in domain " + (Object)((Object)cluster.getDomain()), cluster.getDomain(), SCRIPT_RESOURCE_PATH, CreateWlsJmsModuleStep.getArgs(module, cluster));
    }

    private static String[] getArgs(WlsJmsModule module, WlsCluster cluster) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(module.getName());
        String jmsServerPrefix = CreateWlsJmsModuleStep.createJMServerPrefix(module.getName());
        args.add(cluster.getName());
        List<WlsServer> sortedServers = WlsServer.toNameSortedList(cluster.getServers());
        for (int i = 0; i < sortedServers.size(); ++i) {
            WlsServer server = sortedServers.get(i);
            int jmsServerIndex = i + 1;
            String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
            String jmsFileStoreName = jmsServerPrefix + "-JMSFileStore_" + jmsServerIndex;
            args.add(server.getName());
            args.add(jmsServerName);
            args.add(jmsFileStoreName);
            args.add(WlsConventions.getFilestorePath(cluster.getDomain()));
            args.add(jmsServerName + "-subdeployment");
        }
        return args.toArray(new String[args.size()]);
    }

    protected static String createJMServerPrefix(String moduleName) {
        return StringUtils.remove((String)moduleName, (String)"-JMSModule");
    }
}

