/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueueSet;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWlsJmsQueueSetStep
extends SimpleWlstExecutingStep {
    public static final String SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/wls/step/create-jms-queueset.py";

    public CreateWlsJmsQueueSetStep(Host domainHost, WlsDomain domain, WlsJmsModule targetModule, WlsJmsQueueSet queue, Set<WlsServer> servers) {
        super("Create JMS QueueSet " + (Object)((Object)queue) + " in domain " + (Object)((Object)domain) + " in module " + (Object)((Object)targetModule), domain, SCRIPT_RESOURCE_PATH, CreateWlsJmsQueueSetStep.getArgs(targetModule, queue, servers));
    }

    private static String[] getArgs(WlsJmsModule targetModule, WlsJmsQueueSet queue, Set<WlsServer> servers) {
        ArrayList<String> args = new ArrayList<String>();
        String targetModuleName = targetModule.getName();
        args.add(targetModuleName);
        args.add(queue.getName());
        args.add(queue.getJndiName());
        args.add(String.valueOf(queue.getRedeliveryLimits()));
        String jmsServerPrefix = CreateWlsJmsQueueSetStep.createJMServerPrefix(targetModuleName);
        List<WlsServer> sortedServers = WlsServer.toNameSortedList(servers);
        for (int i = 0; i < sortedServers.size(); ++i) {
            int jmsServerIndex = i + 1;
            String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
            WlsServer server = sortedServers.get(i);
            args.add(server.getName());
            args.add(jmsServerName);
            args.add(jmsServerName + "-subdeployment");
        }
        return args.toArray(new String[args.size()]);
    }

    protected static List<WlsServer> sortWebLogicServersOnName(Set<WlsServer> servers) {
        ArrayList<WlsServer> sortedServers = new ArrayList<WlsServer>(servers);
        Collections.sort(sortedServers, new BeanComparator("name"));
        return sortedServers;
    }

    protected static String createJMServerPrefix(String moduleName) {
        return StringUtils.remove((String)moduleName, (String)"-JMSModule");
    }
}

