/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.util.ArrayList;

public class WlsDeployArtifactStep
extends WlsStepBase {
    public static final String EAR_EXTENSION = ".ear";
    public static final String WAR_EXTENSION = ".war";
    public static final String EJB_JAR_EXTENSION = ".jar";
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-application.py";
    private String targetName;
    private String applicationName;
    private String extension;
    private String applicationLocation;

    public WlsDeployArtifactStep(WlsCluster cluster, Ear application) {
        super(cluster.getDomain());
        this.targetName = cluster.getName();
        this.applicationName = application.getName();
        this.extension = EAR_EXTENSION;
        this.applicationLocation = application.getLocation();
        this.setDescription("Deploy EAR " + application + " on cluster " + (Object)((Object)cluster));
    }

    public WlsDeployArtifactStep(WlsServer server, Ear application) {
        super(server.getDomain());
        this.targetName = server.getName();
        this.applicationName = application.getName();
        this.extension = EAR_EXTENSION;
        this.applicationLocation = application.getLocation();
        this.setDescription("Deploy EAR " + application + " on server " + (Object)((Object)server));
    }

    public WlsDeployArtifactStep(WlsCluster cluster, War application) {
        super(cluster.getDomain());
        this.targetName = cluster.getName();
        this.applicationName = application.getName();
        this.extension = WAR_EXTENSION;
        this.applicationLocation = application.getLocation();
        this.setDescription("Deploy WAR " + application + " on cluster " + (Object)((Object)cluster));
    }

    public WlsDeployArtifactStep(WlsServer server, War application) {
        super(server.getDomain());
        this.targetName = server.getName();
        this.applicationName = application.getName();
        this.extension = WAR_EXTENSION;
        this.applicationLocation = application.getLocation();
        this.setDescription("Deploy WAR " + application + " on server " + (Object)((Object)server));
    }

    public WlsDeployArtifactStep(WlsCluster cluster, EjbJar application) {
        super(cluster.getDomain());
        this.targetName = cluster.getName();
        this.applicationName = application.getName();
        this.extension = EJB_JAR_EXTENSION;
        this.applicationLocation = application.getLocation();
        this.setDescription("Deploy EJB " + application + " on cluster " + (Object)((Object)cluster));
    }

    public WlsDeployArtifactStep(WlsServer server, EjbJar application) {
        super(server.getDomain());
        this.targetName = server.getName();
        this.applicationName = application.getName();
        this.extension = EJB_JAR_EXTENSION;
        this.applicationLocation = application.getLocation();
        this.setDescription("Deploy EJB " + application + " on server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            HostFile uploadedApplication = this.uploadApplication(rhs);
            String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(this.domain.getUsername());
            argsList.add(this.domain.getPassword());
            argsList.add(this.domain.getConnectUrl());
            argsList.add(this.targetName);
            argsList.add(this.applicationName);
            argsList.add(uploadedApplicationPath);
            String[] args = argsList.toArray(new String[argsList.size()]);
            int res = this.executeWlstJythonScriptResource(ctx, rhs, DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME, args);
            boolean bl = res == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostFile uploadedApplicationFile;
        HostSession lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
        HostFile applicationFileToUpload = lhs.getFile(this.applicationLocation);
        try {
            uploadedApplicationFile = rhs.getTempFile(this.applicationName, this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile);
        }
        finally {
            lhs.close();
        }
        return uploadedApplicationFile;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    public String getTargetName() {
        return this.targetName;
    }
}

