#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of Xebialabs Software and Documentation is subject to the Personal
# License Agreement.
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the Xebialabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

modulename = sys.argv.pop(0)
managedServer = sys.argv.pop(0)
queueName = sys.argv.pop(0)
jndiName = sys.argv.pop(0)
redeliveryDelayOverride = sys.argv.pop(0)
redeliveryLimits = sys.argv.pop(0)
expirationPolicy = sys.argv.pop(0)
expirationLoggingFormat = sys.argv.pop(0)
errorQueueName = sys.argv.pop(0)
oldErrorQueueName = sys.argv.pop(0)

#================#
# Simple Queue   #
#================#
def configureSimpleQueue(modulename, managedServer, queueName, jndiName, redeliveryDelayOverride, redeliveryLimits, expirationPolicy, expirationLoggingFormat, errorQueueName, oldErrorQueueName) :
  jmsServerName = getJMSServer(modulename, managedServer);
  print queueName
  print jmsServerName
  print modulename
  log("Creating simple queue: "+queueName+" on associatedManagedServer jmsServer: "+jmsServerName+" and parentModule: " + modulename)
  module2serversname = getSubdeploymentForModuleToJMSServer(modulename, jmsServerName)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename)
#  do not create the queue cmo.createQueue(queueName)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + queueName)
  cmo.setJNDIName(jndiName)
  cmo.setSubDeploymentName(module2serversname)
  cd('/JMSSystemResources/' + modulename + '/SubDeployments/' + module2serversname)
  set('Targets',jarray.array([ObjectName('com.bea:Name=' + jmsServerName + ',Type=JMSServer')], ObjectName))
  if errorQueueName != None:
    setErrorDestination(modulename, queueName, redeliveryDelayOverride, redeliveryLimits, expirationPolicy, expirationLoggingFormat, errorQueueName)
  else:
    if oldErrorQueueName != None:
      # remove the errorDestination
      removeErrorDestination(modulename, queuename)
  return

#=====================================================#
# Retrieve JMSServers for a module and managed server #
#=====================================================#
def getJMSServer(modulename, managedServer):
  subdeploys = get('/JMSSystemResources/'+modulename+'/SubDeployments')
  for deploy in subdeploys:
    targets = get( '/' + getPath(deploy) + '/Targets')
    for target in targets:
      if get( '/' + getPath(target) + '/Type') == 'JMSServer':
        jmsServer = target
        managedServers = get( '/' + getPath(jmsServer) + '/Targets/')
        if len(managedServers)!=0:
            targetManagedServer=managedServers[0]
            targetManagedServerName = get( '/' + getPath(targetManagedServer) + '/Name/')
            if targetManagedServerName == managedServer:
                cd( '/' + getPath(jmsServer)  )
                return cmo.getName()
  return None
  
#============================================#
# Retreive the needed subdeployment          #
#============================================#
def getSubdeploymentForModuleToJMSServer(modulename, jmsservername):
  cd('/')
  module2serversname = ""
  subdeploys = get('/JMSSystemResources/'+modulename+'/SubDeployments')
  for subdeploy in subdeploys:
    targets = get( '/' + getPath(subdeploy) + '/Targets')
    if( len(targets)==1 and get('/'+getPath(targets[0])+'/Type')=='JMSServer' and get('/'+getPath(targets[0])+'/Name')==jmsservername ):
      cd( '/' + getPath(subdeploy)  )
      module2serversname = cmo.getName()
  return module2serversname

#====================#
# Error destination  #
#====================#
def setErrorDestination(modulename, queuename, redeliveryDelayOverride, redeliveryLimits, expirationPolicy, expirationLoggingFormat, errorQueueName):
  log("Setting error destination from "+queuename+" to "+errorQueueName)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + queuename + '/DeliveryFailureParams/' + queuename )
  if errorQueueName != None:
      cmo.setErrorDestination(getMBean('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + errorQueueName))
  cmo.setRedeliveryLimit(int(redeliveryLimits))
  cmo.setExpirationPolicy(expirationPolicy)
  cmo.setExpirationLoggingPolicy(expirationLoggingFormat)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + queuename + '/DeliveryParamsOverrides/' + queuename )
  cmo.setRedeliveryDelay(int(redeliveryDelayOverride))
  return

#====================#
# Remove Error destination  #
#====================#
def removeErrorDestination(modulename, queuename):
  log("Removing error destination from "+queuename+" to "+errorQueueName)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + queuename + '/DeliveryFailureParams/' + queuename )
  cmo.setErrorDestination(None)
  return

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return

#==============================#
# Main Entry Point             #
#==============================#
connect(user, password, url)
edit()
startEdit()
configureSimpleQueue(modulename, managedServer, queueName, jndiName, redeliveryDelayOverride,redeliveryLimits,expirationPolicy,expirationLoggingFormat,errorQueueName, oldErrorQueueName)
save()
disconnect('true')
exit('y')
