/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.WlsConventions;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestroyWlsJmsModuleStep
extends SimpleWlstExecutingStep {
    public DestroyWlsJmsModuleStep(WlsCluster cluster, WlsJmsModule module) {
        super("Destroy JMS Module " + (Object)((Object)module) + " on cluster " + (Object)((Object)cluster), cluster.getDomain(), "com/xebialabs/deployit/plugin/wls/step/destroy-jms-module.py", DestroyWlsJmsModuleStep.getArgs(module.getName(), cluster.getDomain(), cluster.getServers(), WlsConventions.getFilestorePath(cluster.getDomain())));
    }

    protected static String[] getArgs(String moduleName, WlsDomain domain, Set<WlsServer> servers, String filestorePath) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(moduleName);
        String jmsServerPrefix = DestroyWlsJmsModuleStep.createJMServerPrefix(moduleName);
        List<WlsServer> sortedServers = WlsServer.toNameSortedList(servers);
        for (int i = 0; i < sortedServers.size(); ++i) {
            WlsServer server = sortedServers.get(i);
            int jmsServerIndex = i + 1;
            String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
            String jmsFileStoreName = jmsServerPrefix + "-JMSFileStore_" + jmsServerIndex;
            args.add(server.getName());
            args.add(jmsServerName);
            args.add(jmsFileStoreName);
            args.add(filestorePath);
            args.add(jmsServerName + "-subdeployment");
        }
        return args.toArray(new String[args.size()]);
    }

    protected static String createJMServerPrefix(String moduleName) {
        return StringUtils.remove((String)moduleName, (String)"-JMSModule");
    }
}

