import sys
import os
import time as ptime

#================================#
# arguments for connecting in wlst
#================================#
ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

#=============================================#
# arguments for creating the connection factory
#=============================================#
factoryName = sys.argv.pop(0)
jndiName = sys.argv.pop(0)
moduleName = sys.argv.pop(0)


#============================#
# Create Connection Factory  #
#============================# 
def createConnectionFactory(MODULENAME, JNDINAME, FACTORYNAME):
  log("Creating ConnectionFactory: "+FACTORYNAME)
  cd('/JMSSystemResources/'+MODULENAME+'/JMSResource/'+MODULENAME)
  cf = cmo.createConnectionFactory(FACTORYNAME)
  cf.setJNDIName(JNDINAME)
  cf.setDefaultTargetingEnabled(true)
  cd('/JMSSystemResources/'+MODULENAME+'/JMSResource/'+MODULENAME+'/ConnectionFactories/'+FACTORYNAME+'/TransactionParams/'+FACTORYNAME)
  cmo.setXAConnectionFactoryEnabled(true)
  cd('/JMSSystemResources/'+MODULENAME+'/JMSResource/'+MODULENAME+'/ConnectionFactories/'+FACTORYNAME+'/LoadBalancingParams/'+FACTORYNAME)
  cmo.setServerAffinityEnabled(false)
  cmo.setLoadBalancingEnabled(true)
  return

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
  print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
  return
  

#==============================#
# Main Execution               #
#==============================#  
connect(user, password, url)
edit()
startEdit()
createConnectionFactory(moduleName, jndiName, factoryName)
save()
disconnect('true')
exit('y')